<?php
$post_type          = $settings->post_type;
$filter_tax         = $settings->filter_taxonomy;
$filter_field       = 'tax_' . $post_type . '_' . $filter_tax;
$filter_value       = isset( $settings->{$filter_field} ) ? $settings->{$filter_field} : false;
$filter_matching    = $filter_value ? $settings->{$filter_field . '_matching'} : false;
$filter_terms       = array();
$taxonomy           = get_taxonomy( $filter_tax );
$filter_all_label   = (isset($settings->filter_all_label) && ! empty($settings->filter_all_label)) ? $settings->filter_all_label : esc_html__( 'All', 'woopack' );

$terms_to_show		= isset( $settings->filter_terms ) ? $settings->filter_terms : '';
$terms_to_show_archive		= isset( $settings->filter_archive_terms ) ? $settings->filter_archive_terms : '';
$terms_children_on_archive 	= ( is_tax( $filter_tax ) || is_category() ) && ! empty( $terms_to_show_archive );

if ( $terms_children_on_archive ) {
	$terms_to_show = $terms_to_show_archive;
}

if ( $filter_value ) {
    $filter_term_ids = explode( ",", $filter_value );
    if ( ! $filter_matching ) {
        $filter_terms = get_terms( $filter_tax, array( 'exclude' => $filter_term_ids ) );
    } else {
        foreach ( $filter_term_ids as $filter_term_id ) {
			$filter_terms[] = get_term_by( 'id', $filter_term_id, $filter_tax );
		}
    }
}

if ( 'main_query' === $settings->data_source && $terms_children_on_archive ) {
	$current_term = get_queried_object();
	$current_children = get_term_children( $current_term->term_id, $current_term->taxonomy );
	if ( count( $current_children ) === 0 ) {
		return;
	}
	$terms = array( $current_term );
} else {
	$terms = ( count( $filter_terms ) > 0 ) ? $filter_terms : get_terms( $filter_tax );
}

$count = is_array( $terms ) ? count( $terms ) : 0;

?>

<?php do_action( 'woopack_before_products_grid_filters_wrap' ); ?>

<div class="woopack-product-filters-wrap">
    <div class="woopack-product-filters-toggle">
        <span class="toggle-text"><?php echo $filter_all_label; ?></span>
    </div>
    <ul class="woopack-product-filters">
        <li class="woopack-product-filter woopack-filter-active" data-filter="*" tabindex="0"><?php echo $filter_all_label; ?></li>
        <?php
        if ( $count > 0 ) {
			$terms = apply_filters( 'woopack_grid_filter_terms', $terms, $settings );
			$filtered_terms = array();
			foreach ( $terms as $term ) {
				if ( ! empty( $terms_to_show ) ) {
					if ( 'parent' === $terms_to_show ) {
						if ( $term->parent ) {
							$filtered_terms[] = $term->parent;
							continue;
						} else {
							$filtered_terms[] = $term->term_id;
						}
					} elseif ( 'children' === $terms_to_show ) {
						if ( ! $term->parent ) {
							$filtered_terms = array_merge( $filtered_terms, get_term_children( $term->term_id, $term->taxonomy ) );
							continue;	
						} else {
							$filtered_terms[] = $term->term_id;
						}
					}
				} else {
					$filtered_terms[] = $term->term_id;
				}
			}
			if ( ! is_wp_error( $filtered_terms ) && count( $filtered_terms ) ) {
				$filtered_terms = array_unique( $filtered_terms );
				foreach ( $filtered_terms as $term_id ) {
					$term = get_term( $term_id );
					$slug = $term->slug;
					echo '<li class="woopack-product-filter" data-filter=".' . $taxonomy->name . '-' . $slug . '" data-term="' . $slug . '" data-item-count="' . $term->count . '" tabindex="0" aria-label="' . strip_tags( $term->name ) . '">' . $term->name . '</li>';
				}
			}
		}
        ?>
    </ul>
</div>

<?php do_action( 'woopack_after_products_grid_filters_wrap' ); ?>
