!function(name,definition){if(typeof module!='undefined'&&module.exports)module.exports=definition()
else if(typeof define=='function'&&define.amd)define(name,definition)
else this[name]=definition()}('bowser',function(){var t=true
function detect(ua){function getFirstMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[1])||'';}
function getSecondMatch(regex){var match=ua.match(regex);return(match&&match.length>1&&match[2])||'';}
var iosdevice=getFirstMatch(/(ipod|iphone|ipad)/i).toLowerCase(),likeAndroid=/like android/i.test(ua),android=!likeAndroid&&/android/i.test(ua),nexusMobile=/nexus\s*[0-6]\s*/i.test(ua),nexusTablet=!nexusMobile&&/nexus\s*[0-9]+/i.test(ua),chromeos=/CrOS/.test(ua),silk=/silk/i.test(ua),sailfish=/sailfish/i.test(ua),tizen=/tizen/i.test(ua),webos=/(web|hpw)os/i.test(ua),windowsphone=/windows phone/i.test(ua),windows=!windowsphone&&/windows/i.test(ua),mac=!iosdevice&&!silk&&/macintosh/i.test(ua),linux=!android&&!sailfish&&!tizen&&!webos&&/linux/i.test(ua),edgeVersion=getFirstMatch(/edge\/(\d+(\.\d+)?)/i),versionIdentifier=getFirstMatch(/version\/(\d+(\.\d+)?)/i),tablet=/tablet/i.test(ua),mobile=!tablet&&/[^-]mobi/i.test(ua),xbox=/xbox/i.test(ua),result
if(/opera|opr|opios/i.test(ua)){result={name:'Opera',opera:t,version:versionIdentifier||getFirstMatch(/(?:opera|opr|opios)[\s\/](\d+(\.\d+)?)/i)}}
else if(/coast/i.test(ua)){result={name:'Opera Coast',coast:t,version:versionIdentifier||getFirstMatch(/(?:coast)[\s\/](\d+(\.\d+)?)/i)}}
else if(/yabrowser/i.test(ua)){result={name:'Yandex Browser',yandexbrowser:t,version:versionIdentifier||getFirstMatch(/(?:yabrowser)[\s\/](\d+(\.\d+)?)/i)}}
else if(/ucbrowser/i.test(ua)){result={name:'UC Browser',ucbrowser:t,version:getFirstMatch(/(?:ucbrowser)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/mxios/i.test(ua)){result={name:'Maxthon',maxthon:t,version:getFirstMatch(/(?:mxios)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/epiphany/i.test(ua)){result={name:'Epiphany',epiphany:t,version:getFirstMatch(/(?:epiphany)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/puffin/i.test(ua)){result={name:'Puffin',puffin:t,version:getFirstMatch(/(?:puffin)[\s\/](\d+(?:\.\d+)?)/i)}}
else if(/sleipnir/i.test(ua)){result={name:'Sleipnir',sleipnir:t,version:getFirstMatch(/(?:sleipnir)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(/k-meleon/i.test(ua)){result={name:'K-Meleon',kMeleon:t,version:getFirstMatch(/(?:k-meleon)[\s\/](\d+(?:\.\d+)+)/i)}}
else if(windowsphone){result={name:'Windows Phone',windowsphone:t}
if(edgeVersion){result.msedge=t
result.version=edgeVersion}
else{result.msie=t
result.version=getFirstMatch(/iemobile\/(\d+(\.\d+)?)/i)}}
else if(/msie|trident/i.test(ua)){result={name:'Internet Explorer',msie:t,version:getFirstMatch(/(?:msie |rv:)(\d+(\.\d+)?)/i)}}else if(chromeos){result={name:'Chrome',chromeos:t,chromeBook:t,chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}else if(/chrome.+? edge/i.test(ua)){result={name:'Microsoft Edge',msedge:t,version:edgeVersion}}
else if(/vivaldi/i.test(ua)){result={name:'Vivaldi',vivaldi:t,version:getFirstMatch(/vivaldi\/(\d+(\.\d+)?)/i)||versionIdentifier}}
else if(sailfish){result={name:'Sailfish',sailfish:t,version:getFirstMatch(/sailfish\s?browser\/(\d+(\.\d+)?)/i)}}
else if(/seamonkey\//i.test(ua)){result={name:'SeaMonkey',seamonkey:t,version:getFirstMatch(/seamonkey\/(\d+(\.\d+)?)/i)}}
else if(/firefox|iceweasel|fxios/i.test(ua)){result={name:'Firefox',firefox:t,version:getFirstMatch(/(?:firefox|iceweasel|fxios)[ \/](\d+(\.\d+)?)/i)}
if(/\((mobile|tablet);[^\)]*rv:[\d\.]+\)/i.test(ua)){result.firefoxos=t}}
else if(silk){result={name:'Amazon Silk',silk:t,version:getFirstMatch(/silk\/(\d+(\.\d+)?)/i)}}
else if(/phantom/i.test(ua)){result={name:'PhantomJS',phantom:t,version:getFirstMatch(/phantomjs\/(\d+(\.\d+)?)/i)}}
else if(/slimerjs/i.test(ua)){result={name:'SlimerJS',slimer:t,version:getFirstMatch(/slimerjs\/(\d+(\.\d+)?)/i)}}
else if(/blackberry|\bbb\d+/i.test(ua)||/rim\stablet/i.test(ua)){result={name:'BlackBerry',blackberry:t,version:versionIdentifier||getFirstMatch(/blackberry[\d]+\/(\d+(\.\d+)?)/i)}}
else if(webos){result={name:'WebOS',webos:t,version:versionIdentifier||getFirstMatch(/w(?:eb)?osbrowser\/(\d+(\.\d+)?)/i)};if(/touchpad\//i.test(ua)){result.touchpad=t;}}
else if(/bada/i.test(ua)){result={name:'Bada',bada:t,version:getFirstMatch(/dolfin\/(\d+(\.\d+)?)/i)};}
else if(tizen){result={name:'Tizen',tizen:t,version:getFirstMatch(/(?:tizen\s?)?browser\/(\d+(\.\d+)?)/i)||versionIdentifier};}
else if(/qupzilla/i.test(ua)){result={name:'QupZilla',qupzilla:t,version:getFirstMatch(/(?:qupzilla)[\s\/](\d+(?:\.\d+)+)/i)||versionIdentifier}}
else if(/chromium/i.test(ua)){result={name:'Chromium',chromium:t,version:getFirstMatch(/(?:chromium)[\s\/](\d+(?:\.\d+)?)/i)||versionIdentifier}}
else if(/chrome|crios|crmo/i.test(ua)){result={name:'Chrome',chrome:t,version:getFirstMatch(/(?:chrome|crios|crmo)\/(\d+(\.\d+)?)/i)}}
else if(android){result={name:'Android',version:versionIdentifier}}
else if(/safari|applewebkit/i.test(ua)){result={name:'Safari',safari:t}
if(versionIdentifier){result.version=versionIdentifier}}
else if(iosdevice){result={name:iosdevice=='iphone'?'iPhone':iosdevice=='ipad'?'iPad':'iPod'}
if(versionIdentifier){result.version=versionIdentifier}}
else if(/googlebot/i.test(ua)){result={name:'Googlebot',googlebot:t,version:getFirstMatch(/googlebot\/(\d+(\.\d+))/i)||versionIdentifier}}
else{result={name:getFirstMatch(/^(.*)\/(.*) /),version:getSecondMatch(/^(.*)\/(.*) /)};}
if(!result.msedge&&/(apple)?webkit/i.test(ua)){if(/(apple)?webkit\/537\.36/i.test(ua)){result.name=result.name||"Blink"
result.blink=t}else{result.name=result.name||"Webkit"
result.webkit=t}
if(!result.version&&versionIdentifier){result.version=versionIdentifier}}else if(!result.opera&&/gecko\//i.test(ua)){result.name=result.name||"Gecko"
result.gecko=t
result.version=result.version||getFirstMatch(/gecko\/(\d+(\.\d+)?)/i)}
if(!result.msedge&&(android||result.silk)){result.android=t}else if(iosdevice){result[iosdevice]=t
result.ios=t}else if(mac){result.mac=t}else if(xbox){result.xbox=t}else if(windows){result.windows=t}else if(linux){result.linux=t}
var osVersion='';if(result.windowsphone){osVersion=getFirstMatch(/windows phone (?:os)?\s?(\d+(\.\d+)*)/i);}else if(iosdevice){osVersion=getFirstMatch(/os (\d+([_\s]\d+)*) like mac os x/i);osVersion=osVersion.replace(/[_\s]/g,'.');}else if(android){osVersion=getFirstMatch(/android[ \/-](\d+(\.\d+)*)/i);}else if(result.webos){osVersion=getFirstMatch(/(?:web|hpw)os\/(\d+(\.\d+)*)/i);}else if(result.blackberry){osVersion=getFirstMatch(/rim\stablet\sos\s(\d+(\.\d+)*)/i);}else if(result.bada){osVersion=getFirstMatch(/bada\/(\d+(\.\d+)*)/i);}else if(result.tizen){osVersion=getFirstMatch(/tizen[\/\s](\d+(\.\d+)*)/i);}
if(osVersion){result.osversion=osVersion;}
var osMajorVersion=osVersion.split('.')[0];if(tablet||nexusTablet||iosdevice=='ipad'||(android&&(osMajorVersion==3||(osMajorVersion>=4&&!mobile)))||result.silk){result.tablet=t}else if(mobile||iosdevice=='iphone'||iosdevice=='ipod'||android||nexusMobile||result.blackberry||result.webos||result.bada){result.mobile=t}
if(result.msedge||(result.msie&&result.version>=10)||(result.yandexbrowser&&result.version>=15)||(result.vivaldi&&result.version>=1.0)||(result.chrome&&result.version>=20)||(result.firefox&&result.version>=20.0)||(result.safari&&result.version>=6)||(result.opera&&result.version>=10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]>=6)||(result.blackberry&&result.version>=10.1)||(result.chromium&&result.version>=20)){result.a=t;}
else if((result.msie&&result.version<10)||(result.chrome&&result.version<20)||(result.firefox&&result.version<20.0)||(result.safari&&result.version<6)||(result.opera&&result.version<10.0)||(result.ios&&result.osversion&&result.osversion.split(".")[0]<6)||(result.chromium&&result.version<20)){result.c=t}else result.x=t
return result}
var bowser=detect(typeof navigator!=='undefined'?navigator.userAgent:'')
bowser.test=function(browserList){for(var i=0;i<browserList.length;++i){var browserItem=browserList[i];if(typeof browserItem==='string'){if(browserItem in bowser){return true;}}}
return false;}
function getVersionPrecision(version){return version.split(".").length;}
function map(arr,iterator){var result=[],i;if(Array.prototype.map){return Array.prototype.map.call(arr,iterator);}
for(i=0;i<arr.length;i++){result.push(iterator(arr[i]));}
return result;}
function compareVersions(versions){var precision=Math.max(getVersionPrecision(versions[0]),getVersionPrecision(versions[1]));var chunks=map(versions,function(version){var delta=precision-getVersionPrecision(version);version=version+new Array(delta+1).join(".0");return map(version.split("."),function(chunk){return new Array(20-chunk.length).join("0")+chunk;}).reverse();});while(--precision>=0){if(chunks[0][precision]>chunks[1][precision]){return 1;}
else if(chunks[0][precision]===chunks[1][precision]){if(precision===0){return 0;}}
else{return-1;}}}
function isUnsupportedBrowser(minVersions,strictMode,ua){var _bowser=bowser;if(typeof strictMode==='string'){ua=strictMode;strictMode=void(0);}
if(strictMode===void(0)){strictMode=false;}
if(ua){_bowser=detect(ua);}
var version=""+_bowser.version;for(var browser in minVersions){if(minVersions.hasOwnProperty(browser)){if(_bowser[browser]){return compareVersions([version,minVersions[browser]])<0;}}}
return strictMode;}
function check(minVersions,strictMode,ua){return!isUnsupportedBrowser(minVersions,strictMode,ua);}
bowser.isUnsupportedBrowser=isUnsupportedBrowser;bowser.compareVersions=compareVersions;bowser.check=check;bowser._detect=detect;return bowser});(function($){UABBTrigger={triggerHook:function(hook,args)
{$('body').trigger('uabb-trigger.'+hook,args);},addHook:function(hook,callback)
{$('body').on('uabb-trigger.'+hook,callback);},removeHook:function(hook,callback)
{$('body').off('uabb-trigger.'+hook,callback);},};})(jQuery);jQuery(document).ready(function($){if(typeof bowser!=='undefined'&&bowser!==null){var uabb_browser=bowser.name,uabb_browser_v=bowser.version,uabb_browser_class=uabb_browser.replace(/\s+/g,'-').toLowerCase(),uabb_browser_v_class=uabb_browser_class+parseInt(uabb_browser_v);$('html').addClass(uabb_browser_class).addClass(uabb_browser_v_class);}
$('.uabb-row-separator').parents('html').css('overflow-x','hidden');});var wpAjaxUrl='https://www.premium-colostrum.com.au/wp-admin/admin-ajax.php';var flBuilderUrl='https://www.premium-colostrum.com.au/wp-content/plugins/bb-plugin/';var FLBuilderLayoutConfig={anchorLinkAnimations:{duration:1000,easing:'swing',offset:100},paths:{pluginUrl:'https://www.premium-colostrum.com.au/wp-content/plugins/bb-plugin/',wpAjaxUrl:'https://www.premium-colostrum.com.au/wp-admin/admin-ajax.php'},breakpoints:{small:768,medium:992},waypoint:{offset:80}};(function($){if(typeof FLBuilderLayout!='undefined'){return;}
FLBuilderLayout={init:function()
{FLBuilderLayout._destroy();FLBuilderLayout._initClasses();FLBuilderLayout._initBackgrounds();if(0===$('.fl-builder-edit').length){FLBuilderLayout._initModuleAnimations();FLBuilderLayout._initAnchorLinks();FLBuilderLayout._initHash();FLBuilderLayout._initForms();}},refreshGalleries:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),mfContent=$element.find('.fl-mosaicflow-content'),wmContent=$element.find('.fl-gallery'),mfObject=null;if(mfContent){mfObject=mfContent.data('mosaicflow');if(mfObject){mfObject.columns=$([]);mfObject.columnsHeights=[];mfContent.data('mosaicflow',mfObject);mfContent.mosaicflow('refill');}}
if(wmContent){wmContent.trigger('refreshWookmark');}},refreshGridLayout:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),msnryContent=$element.find('.masonry');if(msnryContent.length){msnryContent.masonry('layout');}},reloadSlider:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),bxContent=$element.find('.bx-viewport > div').eq(0),bxObject=null;if(bxContent.length){bxObject=bxContent.data('bxSlider');if(bxObject){bxObject.reloadSlider();}}},resizeAudio:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio'),player=null,mejsPlayer=null,rail=null,railWidth=400;if(audioPlayers.length&&typeof mejs!=='undefined'){audioPlayers.each(function(){player=$(this);mejsPlayer=mejs.players[player.attr('id')];rail=player.find('.mejs-controls .mejs-time-rail');var innerMejs=player.find('.mejs-inner'),total=player.find('.mejs-controls .mejs-time-total');if(typeof mejsPlayer!=='undefined'){railWidth=Math.ceil(player.width()*0.8);if(innerMejs.length){rail.css('width',railWidth+'px!important');mejsPlayer.options.autosizeProgress=true;setTimeout(function(){mejsPlayer.setControlsSize();},50);player.find('.mejs-inner').css({visibility:'visible',height:'inherit'});}}});}},preloadAudio:function(element)
{var $element='undefined'==typeof element?$('body'):$(element),contentWrap=$element.closest('.fl-accordion-item'),audioPlayers=$element.find('.wp-audio-shortcode.mejs-audio');if(!contentWrap.hasClass('fl-accordion-item-active')&&audioPlayers.find('.mejs-inner').length){audioPlayers.find('.mejs-inner').css({visibility:'hidden',height:0});}},resizeSlideshow:function(){if(typeof YUI!=='undefined'){YUI().use('node-event-simulate',function(Y){Y.one(window).simulate("resize");});}},reloadGoogleMap:function(element){var $element='undefined'==typeof element?$('body'):$(element),googleMap=$element.find('iframe[src*="google.com/maps"]');if(googleMap.length){googleMap.attr('src',function(i,val){return val;});}},_destroy:function()
{var win=$(window);win.off('scroll.fl-bg-parallax');win.off('resize.fl-bg-video');},_isTouch:function()
{if(('ontouchstart'in window)||(window.DocumentTouch&&document instanceof DocumentTouch)){return true;}
return false;},_isMobile:function()
{return/Mobile|Android|Silk\/|Kindle|BlackBerry|Opera Mini|Opera Mobi|webOS/i.test(navigator.userAgent);},_initClasses:function()
{var body=$('body'),ua=navigator.userAgent;if(!body.hasClass('archive')&&$('.fl-builder-content-primary').length>0){body.addClass('fl-builder');}
if(FLBuilderLayout._isTouch()){body.addClass('fl-builder-touch');}
if(FLBuilderLayout._isMobile()){body.addClass('fl-builder-mobile');}
if($(window).width()<FLBuilderLayoutConfig.breakpoints.small){body.addClass('fl-builder-breakpoint-small');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.small&&$(window).width()<FLBuilderLayoutConfig.breakpoints.medium){body.addClass('fl-builder-breakpoint-medium');}
if($(window).width()>FLBuilderLayoutConfig.breakpoints.medium){body.addClass('fl-builder-breakpoint-large');}
if(ua.indexOf('Trident/7.0')>-1&&ua.indexOf('rv:11.0')>-1){body.addClass('fl-builder-ie-11');}},_initBackgrounds:function()
{var win=$(window);if($('.fl-row-bg-parallax').length>0&&!FLBuilderLayout._isMobile()){FLBuilderLayout._scrollParallaxBackgrounds();FLBuilderLayout._initParallaxBackgrounds();win.on('scroll.fl-bg-parallax',FLBuilderLayout._scrollParallaxBackgrounds);}
if($('.fl-bg-video').length>0){FLBuilderLayout._initBgVideos();FLBuilderLayout._resizeBgVideos();win.on('resize.fl-bg-video',FLBuilderLayout._resizeBgVideos);}},_initParallaxBackgrounds:function()
{$('.fl-row-bg-parallax').each(FLBuilderLayout._initParallaxBackground);},_initParallaxBackground:function()
{var row=$(this),content=row.find('> .fl-row-content-wrap'),src=row.data('parallax-image'),loaded=row.data('parallax-loaded'),img=new Image();if(loaded){return;}
else if(typeof src!='undefined'){$(img).on('load',function(){content.css('background-image','url('+src+')');row.data('parallax-loaded',true);});img.src=src;}},_scrollParallaxBackgrounds:function()
{$('.fl-row-bg-parallax').each(FLBuilderLayout._scrollParallaxBackground);},_scrollParallaxBackground:function()
{var win=$(window),row=$(this),content=row.find('> .fl-row-content-wrap'),speed=row.data('parallax-speed'),offset=content.offset(),yPos=-((win.scrollTop()-offset.top)/speed);content.css('background-position','center '+yPos+'px');},_initBgVideos:function()
{$('.fl-bg-video').each(FLBuilderLayout._initBgVideo);},_initBgVideo:function()
{var wrap=$(this),width=wrap.data('width'),height=wrap.data('height'),mp4=wrap.data('mp4'),youtube=wrap.data('youtube'),vimeo=wrap.data('vimeo'),mp4Type=wrap.data('mp4-type'),webm=wrap.data('webm'),webmType=wrap.data('webm-type'),fallback=wrap.data('fallback'),loaded=wrap.data('loaded'),videoMobile=wrap.data('video-mobile'),fallbackTag='',videoTag=null,mp4Tag=null,webmTag=null;if(loaded){return;}
videoTag=$('<video autoplay loop muted playsinline></video>');if('undefined'!=typeof fallback&&''!=fallback){videoTag.attr('poster','data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7')
videoTag.css('background','transparent url("'+fallback+'") no-repeat center center')
videoTag.css('background-size','cover')
videoTag.css('height','100%')}
if('undefined'!=typeof mp4&&''!=mp4){mp4Tag=$('<source />');mp4Tag.attr('src',mp4);mp4Tag.attr('type',mp4Type);videoTag.append(mp4Tag);}
if('undefined'!=typeof webm&&''!=webm){webmTag=$('<source />');webmTag.attr('src',webm);webmTag.attr('type',webmType);videoTag.append(webmTag);}
if(!FLBuilderLayout._isMobile()||(FLBuilderLayout._isMobile()&&"yes"==videoMobile)){if('undefined'!=typeof youtube){FLBuilderLayout._initYoutubeBgVideo.apply(this);}
else if('undefined'!=typeof vimeo){FLBuilderLayout._initVimeoBgVideo.apply(this);}
else{wrap.append(videoTag);}}
else{videoTag.attr('src','')
wrap.append(videoTag);}
wrap.data('loaded',true);},_initYoutubeBgVideo:function()
{var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),startTime='undefined'!==typeof playerWrap.data('start')?playerWrap.data('start'):0,endTime='undefined'!==typeof playerWrap.data('end')?playerWrap.data('end'):0,loop='undefined'!==typeof playerWrap.data('loop')?playerWrap.data('loop'):1,stateCount=0,player,fallback_showing;if(videoId){fallback=playerWrap.data('fallback')||false
if(fallback){playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');fallbackTag.css('background-size','cover');fallbackTag.css('transition','background-image 1s')
playerWrap.append(fallbackTag);fallback_showing=true;}
FLBuilderLayout._onYoutubeApiReady(function(YT){setTimeout(function(){player=new YT.Player(videoPlayer[0],{videoId:videoId,events:{onReady:function(event){if("no"===enableAudio||FLBuilderLayout._isMobile()){event.target.mute();}
else if("yes"===enableAudio&&event.target.isMuted){event.target.unMute();}
playerWrap.data('YTPlayer',player);FLBuilderLayout._resizeYoutubeBgVideo.apply(playerWrap);event.target.playVideo();if(audioButton.length>0&&!FLBuilderLayout._isMobile()){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}},onStateChange:function(event){if(event.data===1){if(fallback_showing){$('.fl-bg-video-fallback').css('background-image','url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)')}}
if(stateCount<4){stateCount++;}
if(stateCount>1&&(-1===event.data||2===event.data)&&"yes"===enableAudio){player.mute();player.playVideo();audioButton.show();}
if(event.data===YT.PlayerState.ENDED&&1===loop){if(startTime>0){player.seekTo(startTime);}
else{player.playVideo();}}},onError:function(event){console.info('YT Error: '+event.data)
FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)}},playerVars:{playsinline:FLBuilderLayout._isMobile()?1:0,controls:0,showinfo:0,rel:0,start:startTime,end:endTime,}});},1);});}},_onErrorYoutubeVimeo:function(playerWrap){fallback=playerWrap.data('fallback')||false
if(!fallback){return false;}
playerWrap.find('iframe').remove()
fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+playerWrap.data('fallback')+')');playerWrap.append(fallbackTag);},_onYoutubeApiReady:function(callback){if(window.YT&&YT.loaded){callback(YT);}else{setTimeout(function(){FLBuilderLayout._onYoutubeApiReady(callback);},350);}},_initVimeoBgVideo:function()
{var playerWrap=$(this),videoId=playerWrap.data('video-id'),videoPlayer=playerWrap.find('.fl-bg-video-player'),enableAudio=playerWrap.data('enable-audio'),audioButton=playerWrap.find('.fl-bg-video-audio'),player,width=playerWrap.outerWidth(),ua=navigator.userAgent;if(typeof Vimeo!=='undefined'&&videoId){player=new Vimeo.Player(videoPlayer[0],{id:videoId,loop:true,title:false,portrait:false,background:true,autopause:false,muted:true});playerWrap.data('VMPlayer',player);if("no"===enableAudio){player.setVolume(0);}
else if("yes"===enableAudio){if(ua.indexOf("Safari")>-1||ua.indexOf("Chrome")>-1){player.setVolume(0);audioButton.show();}
else{player.setVolume(1);}}
player.play().catch(function(error){FLBuilderLayout._onErrorYoutubeVimeo(playerWrap)});if(audioButton.length>0){audioButton.on('click',{button:audioButton,player:player},FLBuilderLayout._toggleBgVideoAudio);}}},_toggleBgVideoAudio:function(e){var player=e.data.player,control=e.data.button.find('.fl-audio-control');if(control.hasClass('fa-volume-off')){control.removeClass('fa-volume-off').addClass('fa-volume-up');e.data.button.find('.fa-times').hide();if('function'===typeof player.unMute){player.unMute();}
else{player.setVolume(1);}}
else{control.removeClass('fa-volume-up').addClass('fa-volume-off');e.data.button.find('.fa-times').show();if('function'===typeof player.unMute){player.mute();}
else{player.setVolume(0);}}},_videoBgSourceError:function(e)
{var source=$(e.target),wrap=source.closest('.fl-bg-video'),vid=wrap.find('video'),fallback=wrap.data('fallback'),fallbackTag='';source.remove();if(vid.find('source').length){return;}else if(''!==fallback){fallbackTag=$('<div></div>');fallbackTag.addClass('fl-bg-video-fallback');fallbackTag.css('background-image','url('+fallback+')');wrap.append(fallbackTag);vid.remove();}},_resizeBgVideos:function()
{$('.fl-bg-video').each(function(){FLBuilderLayout._resizeBgVideo.apply(this);if($(this).parent().find('img').length>0){$(this).parent().imagesLoaded($.proxy(FLBuilderLayout._resizeBgVideo,this));}});},_resizeBgVideo:function()
{if(0===$(this).find('video').length&&0===$(this).find('iframe').length){return;}
var wrap=$(this),wrapHeight=wrap.outerHeight(),wrapWidth=wrap.outerWidth(),vid=wrap.find('video'),vidHeight=wrap.data('height'),vidWidth=wrap.data('width'),newWidth=wrapWidth,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newLeft=0,newTop=0,iframe=wrap.find('iframe');if(vid.length){if(vidHeight===''||typeof vidHeight==='undefined'||vidWidth===''||typeof vidWidth==='undefined'){vid.css({'left':'0px','top':'0px','width':newWidth+'px'});vid.on('loadedmetadata',FLBuilderLayout._resizeOnLoadedMeta);}
else{if(newHeight<wrapHeight){newHeight=wrapHeight;newWidth=Math.round(vidWidth*wrapHeight/vidHeight);newLeft=-((newWidth-wrapWidth)/2);}
else{newTop=-((newHeight-wrapHeight)/2);}
vid.css({'left':newLeft+'px','top':newTop+'px','height':newHeight+'px','width':newWidth+'px'});}}
else if(iframe.length){if(typeof wrap.data('youtube')!=='undefined'){FLBuilderLayout._resizeYoutubeBgVideo.apply(this);}}},_resizeOnLoadedMeta:function(){var video=$(this),wrapHeight=video.parent().outerHeight(),wrapWidth=video.parent().outerWidth(),vidWidth=video[0].videoWidth,vidHeight=video[0].videoHeight,newHeight=Math.round(vidHeight*wrapWidth/vidWidth),newWidth=wrapWidth,newLeft=0,newTop=0;if(newHeight<wrapHeight){newHeight=wrapHeight;newWidth=Math.round(vidWidth*wrapHeight/vidHeight);newLeft=-((newWidth-wrapWidth)/2);}
else{newTop=-((newHeight-wrapHeight)/2);}
video.parent().data('width',vidWidth);video.parent().data('height',vidHeight);video.css({'left':newLeft+'px','top':newTop+'px','width':newWidth+'px','height':newHeight+'px'});},_resizeYoutubeBgVideo:function()
{var wrap=$(this),wrapWidth=wrap.outerWidth(),wrapHeight=wrap.outerHeight(),player=wrap.data('YTPlayer'),video=player?player.getIframe():null,aspectRatioSetting='16:9',aspectRatioArray=aspectRatioSetting.split(':'),aspectRatio=aspectRatioArray[0]/aspectRatioArray[1],ratioWidth=wrapWidth/aspectRatio,ratioHeight=wrapHeight*aspectRatio,isWidthFixed=wrapWidth/wrapHeight>aspectRatio,width=isWidthFixed?wrapWidth:ratioHeight,height=isWidthFixed?ratioWidth:wrapHeight;if(video){$(video).width(width).height(height);}},_initModuleAnimations:function()
{if(typeof jQuery.fn.waypoint!=='undefined'){$('.fl-animation').each(function(){var node=$(this),nodeTop=node.offset().top,winHeight=$(window).height(),bodyHeight=$('body').height(),waypoint=FLBuilderLayoutConfig.waypoint,offset='80%';if(typeof waypoint.offset!==undefined){offset=FLBuilderLayoutConfig.waypoint.offset+'%';}
if(bodyHeight-nodeTop<winHeight*0.2){offset='100%';}
node.waypoint({offset:offset,handler:FLBuilderLayout._doModuleAnimation});});}},_doModuleAnimation:function()
{var module='undefined'==typeof this.element?$(this):$(this.element),delay=parseFloat(module.data('animation-delay')),duration=parseFloat(module.data('animation-duration'));if(!isNaN(duration)){module.css('animation-duration',duration+'s');}
if(!isNaN(delay)&&delay>0){setTimeout(function(){module.addClass('fl-animated');},delay*1000);}else{setTimeout(function(){module.addClass('fl-animated');},1);}},_initHash:function()
{var hash=window.location.hash.replace('#','').split('/').shift(),element=null,tabs=null,responsiveLabel=null,tabIndex=null,label=null;if(''!==hash){try{element=$('#'+hash);if(element.length>0){if(element.hasClass('fl-accordion-item')){setTimeout(function(){element.find('.fl-accordion-button').trigger('click');},100);}
if(element.hasClass('fl-tabs-panel')){setTimeout(function(){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');if(responsiveLabel.is(':visible')){responsiveLabel.trigger('click');}
else{label[0].click();FLBuilderLayout._scrollToElement(element);}},100);}}}
catch(e){}}},_initAnchorLinks:function()
{$('a').each(FLBuilderLayout._initAnchorLink);},_initAnchorLink:function()
{var link=$(this),href=link.attr('href'),loc=window.location,id=null,element=null;if('undefined'!=typeof href&&href.indexOf('#')>-1&&link.closest('svg').length<1){if(loc.pathname.replace(/^\//,'')==this.pathname.replace(/^\//,'')&&loc.hostname==this.hostname){try{id=href.split('#').pop();if(!id){return;}
element=$('#'+id);if(element.length>0){if(link.hasClass('fl-scroll-link')||element.hasClass('fl-row')||element.hasClass('fl-col')||element.hasClass('fl-module')){$(link).on('click',FLBuilderLayout._scrollToElementOnLinkClick);}
if(element.hasClass('fl-accordion-item')){$(link).on('click',FLBuilderLayout._scrollToAccordionOnLinkClick);}
if(element.hasClass('fl-tabs-panel')){$(link).on('click',FLBuilderLayout._scrollToTabOnLinkClick);}}}
catch(e){}}}},_scrollToElementOnLinkClick:function(e,callback)
{var element=$('#'+$(this).attr('href').split('#').pop());FLBuilderLayout._scrollToElement(element,callback);e.preventDefault();},_scrollToElement:function(element,callback)
{var config=FLBuilderLayoutConfig.anchorLinkAnimations,dest=0,win=$(window),doc=$(document);if(element.length>0){if(element.offset().top>doc.height()-win.height()){dest=doc.height()-win.height();}
else{dest=element.offset().top-config.offset;}
$('html, body').animate({scrollTop:dest},config.duration,config.easing,function(){if('undefined'!=typeof callback){callback();}
if(undefined!=element.attr('id')){if(history.pushState){history.pushState(null,null,'#'+element.attr('id'));}
else{window.location.hash=element.attr('id');}}});}},_scrollToAccordionOnLinkClick:function(e)
{var element=$('#'+$(this).attr('href').split('#').pop());if(element.length>0){var callback=function(){if(element){element.find('.fl-accordion-button').trigger('click');element=false;}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}},_scrollToTabOnLinkClick:function(e)
{var element=$('#'+$(this).attr('href').split('#').pop()),tabs=null,label=null,responsiveLabel=null;if(element.length>0){tabs=element.closest('.fl-tabs');responsiveLabel=element.find('.fl-tabs-panel-label');tabIndex=responsiveLabel.data('index');label=tabs.find('.fl-tabs-labels .fl-tabs-label[data-index='+tabIndex+']');if(responsiveLabel.is(':visible')){var callback=function(){if(element){responsiveLabel.trigger('click');element=false;}};FLBuilderLayout._scrollToElementOnLinkClick.call(this,e,callback);}
else{label[0].click();FLBuilderLayout._scrollToElement(element);}
e.preventDefault();}},_initForms:function()
{if(!FLBuilderLayout._hasPlaceholderSupport){$('.fl-form-field input').each(FLBuilderLayout._initFormFieldPlaceholderFallback);}
$('.fl-form-field input').on('focus',FLBuilderLayout._clearFormFieldError);},_hasPlaceholderSupport:function()
{var input=document.createElement('input');return'undefined'!=input.placeholder;},_initFormFieldPlaceholderFallback:function()
{var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if('undefined'!=placeholder&&''===val){field.val(placeholder);field.on('focus',FLBuilderLayout._hideFormFieldPlaceholderFallback);field.on('blur',FLBuilderLayout._showFormFieldPlaceholderFallback);}},_hideFormFieldPlaceholderFallback:function()
{var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(val==placeholder){field.val('');}},_showFormFieldPlaceholderFallback:function()
{var field=$(this),val=field.val(),placeholder=field.attr('placeholder');if(''===val){field.val(placeholder);}},_clearFormFieldError:function()
{var field=$(this);field.removeClass('fl-form-error');field.siblings('.fl-form-error-message').hide();}};$(function(){FLBuilderLayout.init();});})(jQuery);YUI({'logExclude':{'yui':true}}).use('fl-slideshow',function(Y){if(null===Y.one('.fl-node-5e738fb233bc2 .fl-bg-slideshow')){return;}
var oldSlideshow=Y.one('.fl-node-5e738fb233bc2 .fl-bg-slideshow .fl-slideshow'),newSlideshow=new Y.FL.Slideshow({autoPlay:true,bgslideshow:true,crop:true,loadingImageEnabled:false,randomize:false,responsiveThreshold:0,touchSupport:false,source:[{type:"urls",urls:[{thumbURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Smiling-Healthy-young-lady-150x150.jpg",largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Smiling-Healthy-young-lady-1024x576.jpg",x3largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Smiling-Healthy-young-lady.jpg",caption:"Beautiful woman with a whiten perfect smile outdoor with a green background",alt:"",},{thumbURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Mother-and-daughter-happy-healthy-150x150.jpg",largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Mother-and-daughter-happy-healthy-1024x576.jpg",x3largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Mother-and-daughter-happy-healthy.jpg",caption:"Mother and daughter in the park",alt:"",},{thumbURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Breathing-in-the-fresh-air-150x150.jpg",largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Breathing-in-the-fresh-air-1024x576.jpg",x3largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/Breathing-in-the-fresh-air.jpg",caption:"",alt:"Breathing in the fresh Air Healthy start to the day",},{thumbURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/The-lives-we-cherish-150x150.jpg",largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/The-lives-we-cherish-1024x576.jpg",x3largeURL:"https://www.premium-colostrum.com.au/wp-content/uploads/2020/10/The-lives-we-cherish.jpg",caption:"",alt:"The lives we cherish protecting the health",}]}],speed:3000,stretchy:true,stretchyType:'contain',transition:'fade',transitionDuration:1});if(oldSlideshow){oldSlideshow.remove(true);}
jQuery('.fl-node-5e738fb233bc2').imagesLoaded(function(){newSlideshow.render('.fl-node-5e738fb233bc2 .fl-bg-slideshow');});});jQuery(function($){$(function(){$('.fl-node-5fb33c4c551e7 .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){UABBCreativeMenu=function(settings){this.settingsId=settings.id;this.nodeClass='.fl-node-'+settings.id;this.wrapperClass=this.nodeClass+' .uabb-creative-menu';this.type=settings.type;this.mobileToggle=settings.mobile;this.mobileBelowRow=settings.mobileBelowRow;this.breakPoints=settings.breakPoints;this.mobileBreakpoint=settings.mobileBreakpoint;this.mediaBreakpoint=settings.mediaBreakpoint;this.mobileMenuType=settings.mobileMenuType;this.isBuilderActive=settings.isBuilderActive;this.currentBrowserWidth=$(window).width();this._initMenu();$(window).on('resize',$.proxy(function(e){var width=$(window).width();if(width!=this.currentBrowserWidth){this._initMenu();this._clickOrHover();this.currentBrowserWidth=width;}},this));};UABBCreativeMenu.prototype={nodeClass:'',wrapperClass:'',type:'',breakPoints:{},$submenus:null,_isMobile:function(){return $(window).width()<=this.breakPoints.small?true:false;},_isMedium:function(){return $(window).width()<=this.breakPoints.medium?true:false;},_isCustom:function(){return $(window).width()<=this.breakPoints.custom?true:false;},_isMenuToggle:function(){if('always'==this.mobileBreakpoint||(this._isMobile()&&'mobile'==this.mobileBreakpoint)||(this._isMedium()&&'medium-mobile'==this.mobileBreakpoint)||(this._isCustom()&&'custom'==this.mobileBreakpoint)){return true;}
return false;},_initMenu:function(){this._menuOnFocus();if($(this.nodeClass).length){this._initMegaMenus();}
if(this._isMenuToggle()||this.type=='accordion'){$(this.wrapperClass).off('mouseenter mouseleave');this._menuOnClick();this._clickOrHover();}else{$(this.wrapperClass).off('click');this._submenuOnRight();}
if(this.mobileToggle!='expanded'){this._toggleForMobile();this._initBelowRowMenu();if(this.mobileMenuType==='off-canvas'){this._initializeCanvas();}
if(this.mobileMenuType==='full-screen'){this.__initializeFullScreen();}}},_menuOnFocus:function(){$(this.nodeClass).off('focus').on('focus','a',$.proxy(function(e){var $menuItem=$(e.target).parents('.menu-item').first(),$parents=$(e.target).parentsUntil(this.wrapperClass);$('.uabb-creative-menu .focus').removeClass('focus');$menuItem.addClass('focus');$parents.addClass('focus');},this)).on('focusout','a',$.proxy(function(e){$(e.target).parentsUntil(this.wrapperClass).removeClass('focus');},this));},_menuOnClick:function(){$('.uabb-has-submenu-container').off().click($.proxy(function(e){var $link=$(e.target).parents('.uabb-has-submenu').first(),$subMenu=$link.children('.sub-menu').first(),$href=$link.children('.uabb-has-submenu-container').first().find('> a').attr('href'),$subMenuParents=$(e.target).parents('.sub-menu'),$activeParent=$(e.target).closest('.uabb-has-submenu.uabb-active');if(!$subMenu.is(':visible')||$(e.target).hasClass('uabb-menu-toggle')||($subMenu.is(':visible')&&(typeof $href==='undefined'||$href=='#'))){e.preventDefault();}
else{window.location.href=$href;return;}
if($(this.wrapperClass).hasClass('uabb-creative-menu-accordion-collapse')){if(!$link.parents('.menu-item').hasClass('uabb-active')){$('.uabb-active',this.wrapperClass).not($link).removeClass('uabb-active');}
else if($link.parents('.menu-item').hasClass('uabb-active')&&$link.parent('.sub-menu').length){$('.uabb-active',this.wrapperClass).not($link).not($activeParent).removeClass('uabb-active');}
$('.sub-menu',this.wrapperClass).not($subMenu).not($subMenuParents).slideUp('normal');}
$subMenu.slideToggle();$link.toggleClass('uabb-active');},this));},_clickOrHover:function(){this.$submenus=this.$submenus||$(this.wrapperClass).find('.sub-menu');var $wrapper=$(this.wrapperClass),$menu=$wrapper.find('.menu');$li=$wrapper.find('.uabb-has-submenu');if(this._isMenuToggle()){$li.each(function(el){if(!$(this).hasClass('uabb-active')){$(this).find('.sub-menu').fadeOut();}});}else{$li.each(function(el){if(!$(this).hasClass('uabb-active')){$(this).find('.sub-menu').css({'display':'','opacity':''});}});}},_submenuOnRight:function(){$(this.wrapperClass).on('mouseenter','.uabb-has-submenu',$.proxy(function(e){if($(e.currentTarget).find('.sub-menu').length===0){return;}
var $link=$(e.currentTarget),$parent=$link.parent(),$subMenu=$link.find('.sub-menu'),subMenuWidth=$subMenu.width(),subMenuPos=0,winWidth=$(window).width();if($link.closest('.uabb-menu-submenu-right').length!==0){$link.addClass('uabb-menu-submenu-right');}else if($('body').hasClass('rtl')){subMenuPos=$parent.is('.sub-menu')?$parent.offset().left-subMenuWidth:$link.offset().left-subMenuWidth;if(subMenuPos<=0){$link.addClass('uabb-menu-submenu-right');}}else{subMenuPos=$parent.is('.sub-menu')?$parent.offset().left+$parent.width()+subMenuWidth:$link.offset().left+subMenuWidth;if(subMenuPos>winWidth){$link.addClass('uabb-menu-submenu-right');}}},this)).on('mouseleave','.uabb-has-submenu',$.proxy(function(e){$(e.currentTarget).removeClass('uabb-menu-submenu-right');},this));},_toggleForMobile:function(){var $wrapper=null,$menu=null;if(this._isMenuToggle()){$wrapper=$(this.wrapperClass);$menu=$wrapper.children('.menu');if(!$wrapper.find('.uabb-creative-menu-mobile-toggle').hasClass('uabb-active')){if(window.innerWidth<=this.mediaBreakpoint){$menu.css({display:'none'});}else{if(!this.mobileBelowRow=='below-row'){$menu.css({display:'block'});}}}
$wrapper.find('.uabb-creative-menu-mobile-toggle').off().on('focus',function(e){$(this).on('keypress',function(e){if(e.which===13){$(this).trigger('click');}});});$wrapper.off().on('click','.uabb-creative-menu-mobile-toggle',function(e){$(this).toggleClass('uabb-active');$menu.slideToggle();});$menu.on('click','.menu-item > a[href*="#"]',function(e){var $href=$(this).attr('href'),$targetID='';if($href!=='#'){$targetID=$href.split('#')[1];if($('body').find('#'+$targetID).length>0){e.preventDefault();$(this).toggleClass('uabb-active');$menu.slideToggle('fast',function(){setTimeout(function(){$('html, body').animate({scrollTop:$('#'+$targetID).offset().top},1000,function(){window.location.hash=$targetID;});},500);});}}});}
else{$wrapper=$(this.wrapperClass),$menu=$wrapper.children('.menu');$wrapper.find('.uabb-creative-menu-mobile-toggle').removeClass('uabb-active');$menu.css({display:''});}},_initBelowRowMenu:function(){var $wrapper=null,$menu=null;if(this._isMenuToggle()&&(window.innerWidth<=this.mediaBreakpoint||this.mediaBreakpoint=='always')){if(this._isMobileBelowRowEnabled()){this._placeMobileMenuBelowRow();$wrapper=$(this.wrapperClass);$menu=$(this.nodeClass+'-clone');$menu.find('ul.menu').show();}else{$wrapper=$(this.wrapperClass);$menu=$wrapper.children('.menu');}
if(false!=this.mobileBelowRow&&!$wrapper.find('.uabb-creative-menu-mobile-toggle').hasClass('uabb-active')){if(window.innerWidth<=this.mediaBreakpoint||this.mediaBreakpoint=='always'){$menu.css({display:'none'});}else{$menu.css({display:'block'});}}
$wrapper.find('.uabb-creative-menu-mobile-toggle').off().on('focus',function(e){$(this).on('keypress',function(e){if(e.which===13){$(this).trigger('click');}});});$wrapper.off().on('click','.uabb-creative-menu-mobile-toggle',function(e){$(this).toggleClass('uabb-active');$menu.slideToggle();});}else{if(this._isMobileBelowRowEnabled()){this._removeMenuFromBelowRow();}
$wrapper=$(this.wrapperClass),$menu=$wrapper.children('.menu');$wrapper.find('.uabb-creative-menu-mobile-toggle').removeClass('uabb-active');$menu.css({display:''});}},_initializeCanvas:function(){if(this.isBuilderActive){this._toggleMenu();return;}
if('always'===this.mediaBreakpoint||this.mediaBreakpoint>=this.currentBrowserWidth){$(this.nodeClass).find('.uabb-creative-menu.off-canvas').appendTo('body').wrap('<div class="fl-node-'+this.settingsId+'">');}
this._toggleMenu();},__initializeFullScreen:function(){if(this.isBuilderActive){this._toggleMenu();return;}
if('always'===this.mediaBreakpoint||this.mediaBreakpoint>=this.currentBrowserWidth){$(this.nodeClass).find('.uabb-creative-menu.full-screen').appendTo('body').wrap('<div class="fl-node-'+this.settingsId+'">');}
this._toggleMenu();},_toggleMenu:function(){var self=this;$(self.nodeClass).find('.uabb-creative-menu-mobile-toggle').off().on('focus',function(e){$(this).on('keypress',function(e){if(e.which===13){$(this).trigger('click');}});});$(self.nodeClass).find('.uabb-creative-menu-mobile-toggle').off('click').on('click',function(){if($(self.nodeClass).find('.uabb-creative-menu').hasClass('menu-open')){$(self.nodeClass).find('.uabb-creative-menu').addClass('menu-close');$(self.nodeClass).find('.uabb-creative-menu').removeClass('menu-open');}else{$(self.nodeClass).find('.uabb-creative-menu').addClass('menu-open');}});$(self.nodeClass).find('.uabb-creative-menu .uabb-menu-close-btn, .uabb-clear').on('click',function(){$(self.nodeClass).find('.uabb-creative-menu').addClass('menu-close');$(self.nodeClass).find('.uabb-creative-menu').removeClass('menu-open');});if(this.isBuilderActive){setTimeout(function(){if($('.fl-builder-settings[data-node="'+self.settingsId+'"]').length>0){$('.uabb-creative-menu').removeClass('menu-open');$(self.nodeClass).find('.uabb-creative-menu-mobile-toggle').trigger('click');}},600);FLBuilder.addHook('settings-form-init',function(){if(!$('.fl-builder-settings[data-node="'+self.settingsId+'"]').length>0){return;}
if(!$(self.nodeClass).find('.uabb-creative-menu').hasClass('uabb-menu-overlay')){$('.fl-builder-panel').css('z-index','999999');}
if(!$(self.nodeClass).find('.uabb-creative-menu').hasClass('menu-open')){$('.uabb-creative-menu').removeClass('menu-open');$('.uabb-creative-menu-mobile-toggle').removeClass('uabb-active');$(self.nodeClass).find('.uabb-creative-menu-mobile-toggle').trigger('click');}});}},_isMobileBelowRowEnabled:function(){return this.mobileBelowRow&&$(this.nodeClass).closest('.fl-col').length;},_placeMobileMenuBelowRow:function(){if($(this.nodeClass+'-clone').length){return;}
var module=$(this.nodeClass),clone=module.clone(),col=module.closest('.fl-row-content');module.find('ul.menu').css('display','none');clone.addClass((this.nodeClass+'-clone').replace('.',''));clone.find('.uabb-creative-menu-mobile-toggle').remove();col.after(clone);this._menuOnClick();},_removeMenuFromBelowRow:function(){if(!$(this.nodeClass+'-clone').length){return;}
var module=$(this.nodeClass);module.find('ul.menu').css('display','none'),clone=$(this.nodeClass+'-clone');menu=clone.find('ul.menu');module.find('ul.menu').after(menu);clone.remove();},_initMegaMenus:function(){var module=$(this.nodeClass),rowContent=module.closest('.fl-row-content'),rowWidth=rowContent.width(),rowOffset=(rowContent.offset.left!=undefined)?rowContent.offset().left:'',megas=module.find('.mega-menu'),disabled=module.find('.mega-menu-disabled'),isToggle=this._isMenuToggle();if(isToggle){megas.removeClass('mega-menu').addClass('mega-menu-disabled');module.find('li.mega-menu-disabled > ul.sub-menu').css('width','');rowContent.css('position','');}else{disabled.removeClass('mega-menu-disabled').addClass('mega-menu');module.find('li.mega-menu > ul.sub-menu').css('width',rowWidth+'px');rowContent.css('position','relative');}},};})(jQuery);jQuery(document).ready(function(){new UABBCreativeMenu({id:'5fb33cb8012a4',type:'horizontal',mobile:'hamburger',mobileBelowRow:false,breakPoints:{medium:992,small:768,custom:768},mobileBreakpoint:'mobile',mediaBreakpoint:'768',mobileMenuType:'default',fullScreenAnimation:'',isBuilderActive:false});});;(function($){WooPackGrid=function(settings){this.settings=settings;this.nodeClass='.fl-node-'+settings.id;this.wrapperClass=this.nodeClass+' .woopack-products-grid-wrap ul.products';this.postClass=this.wrapperClass+' .woopack-product-grid';this.perPage=settings.perPage;this.matchHeight=settings.matchHeight==='yes'?true:false;this.layoutStyle=settings.layoutStyle;this.masonry=settings.matchHeight==='no'?true:false;this.filters=settings.filters==='yes'?true:false;this.filterTax=settings.filterTax;this.filterType=settings.filterType;this.isotopeData={};this.template=settings.template;this.cacheData={};if(this._hasPosts()){this._initInfiniteScroll();this._gridLayout();this._reLayout();}
$(document).on('woopack.grid.rendered',function(e,obj){if($(obj.postClass).hasClass('product-type-variable')){$.get(woopack_config.woo_url+'assets/js/frontend/add-to-cart-variation.min.js');}});};WooPackGrid.prototype={settings:{},nodeClass:'',wrapperClass:'',postClass:'',perPage:'',matchHeight:false,layoutStyle:1,masonry:false,filters:false,filterTax:'',filterType:'',isotopeData:'',template:'',cacheData:{},_hasPosts:function()
{return $(this.postClass).length>0;},_matchWidth:function()
{var wrap=$(this.wrapperClass);wrap.imagesLoaded($.proxy(function(){if(3==this.layoutStyle||4==this.layoutStyle){var img_width=$(this.postClass+' .woopack-product-image img').attr('width');$(this.postClass+' .woopack-product-content').css({'width':'calc(100% - '+img_width+'px)'});}},this));},_gridLayout:function()
{var self=this;var wrap=$(this.wrapperClass);var postFilterData={itemSelector:'.woopack-product-grid',percentPosition:true,transitionDuration:'0.3s',hiddenStyle:{opacity:0},visibleStyle:{opacity:1},isOriginLeft:!$('body').hasClass('rtl'),};if(!this.masonry){postFilterData=$.extend({},postFilterData,{layoutMode:'fitRows',fitRows:{gutter:'.woopack-grid-sizer'},});}
if(this.masonry){postFilterData=$.extend({},postFilterData,{masonry:{columnWidth:'.woopack-product-grid',gutter:'.woopack-grid-sizer'},});}
this.isotopeData=postFilterData;wrap.imagesLoaded($.proxy(function(){var node=$(this.nodeClass);var base=this;this._initSlider();var postFilters=$(this.nodeClass).find('ul.products').isotope(postFilterData);if(this.filters||this.masonry){var filterWrap=$(this.nodeClass).find('.woopack-product-filters');var filterToggle=$(this.nodeClass).find('.woopack-product-filters-toggle');filterToggle.on('click',function(){filterWrap.slideToggle(function(){if($(this).is(':visible')){$(this).addClass('woopack-product-filters-open');}
if(!$(this).is(':visible')){$(this).removeClass('woopack-product-filters-open');}});});filterWrap.on('click keyup','.woopack-product-filter',function(e){var shouldFilter='click'===e.type||('keyup'===e.type&&(13===e.keyCode||13===e.which))
if(!shouldFilter){return;}
if('static'===base.filterType){var filterVal=$(this).attr('data-filter');postFilters.isotope({filter:filterVal});}else{$(base.nodeClass).addClass('woopack-products-loading');var term=$(this).data('term');base._getPosts(term,postFilterData);}
filterWrap.find('.woopack-product-filter').removeClass('woopack-filter-active');$(this).addClass('woopack-filter-active');filterToggle.find('span.toggle-text').html($(this).text());if(filterWrap.hasClass('woopack-product-filters-open')){filterWrap.slideUp();}
$(base.nodeClass).trigger('grid.filter.change');});if('dynamic'===base.filterType){$(base.nodeClass).find('.fl-builder-pagination a').off('click').on('click',function(e){e.preventDefault();var pageNumber=$(this).attr('href').split('#page-')[1];base.currentPage=pageNumber;base._getPosts('',postFilterData,pageNumber);});}
if(''!==location.hash){var filterHash=location.hash.split('#')[1];filterWrap.find('li[data-term="'+filterHash+'"]').trigger('click');}
$(window).on('hashchange',function(){if(''!==location.hash){var filterHash=location.hash.split('#')[1];filterWrap.find('li[data-term="'+filterHash+'"]').trigger('click');}});}
if(!this.masonry){setTimeout(function(){base._gridLayoutMatchHeight();node.find('ul.products').isotope('layout');},1000);}
if(this.filters||this.masonry){setTimeout(function(){if('static'===base.filterType){node.find('.woopack-filter-active').trigger('click');}
if(!base.masonry){base._gridLayoutMatchHeight();}
node.find('ul.products').isotope('layout');},1000);}},this));},_initSlider:function(){if($('body').hasClass('fl-builder-edit')){return;}
var wrap=$(this.wrapperClass);if(!this.settings.imagesSlider){if('undefined'===typeof wrap.find('.woopack-has-slider').get(0)){return;}}
if('undefined'===typeof jQuery.fn.slick){return;}
wrap.find('.product').each(function(){var product=$(this),slider=$(this).find('.woopack-product-images'),slides=slider.find('.woopack-product-image-slide');if(slides.length>1&&slider.find('.slick-slide').length===0){if(slides.length===1){return;}
var opts={autoplay:true,autoplaySpeed:600,pauseOnHover:false,arrows:false,adaptiveHeight:false,centerMode:false,cssEase:'ease',rtl:$('body').hasClass('rtl')};slider.slick(opts);setTimeout(function(){slider.slick('slickPause');},200);}});wrap.find('.product').on('mouseenter',function(e){e.stopPropagation();var product=$(this),slider=$(this).find('.woopack-product-images'),slides=slider.find('.woopack-product-image-slide');slider.show(function(){if(slides.length>1){slider.slick('slickPlay');}});}).on('mouseleave',function(e){e.stopPropagation();var product=$(this),slider=$(this).find('.woopack-product-images');if(slider.find('.slick-slide').length===0){return;}
slider.slick('slickPause');setTimeout(function(){slider.slick('slickGoTo',0);},100);});},_getPosts:function(term,isotopeData,paged){var processAjax=false,filter=term,paged=(!paged||'undefined'===typeof paged)?1:paged;if('undefined'===typeof term||''===filter){filter='all';}
var cacheData=this._getCacheData(filter);if('undefined'===typeof cacheData){processAjax=true;}else{var cachedResponse=cacheData.page[paged];if('undefined'===typeof cachedResponse){processAjax=true;}else{this._renderPosts(cachedResponse,{term:term,isotopeData:isotopeData,page:paged});}}
if(processAjax){this._getAjaxPosts(term,isotopeData,paged);}},_getAjaxPosts:function(term,isotopeData,paged)
{var taxonomy=this.filterTax,perPage=this.perPage,layout=this.layoutStyle,paged='undefined'===typeof paged?false:paged,self=this;var wrap=$(this.wrapperClass),gridWrap=$(this.nodeClass).find('.woopack-products-grid-wrap');var currentPage=woopack_config.current_page.split('?')[0];var data={woopack_action:'woopack_grid_get_posts',node_id:this.settings.id,paged:!paged?woopack_config.page:paged,current_page:currentPage,settings:this.settings.fields};if(''!==term){data['term']=term;}
if('undefined'!==self.settings.orderby||''!==self.settings.orderby){data['orderby']=self.settings.orderby;}
gridWrap.addClass('woopack-is-filtering');$.ajax({type:'post',url:window.location.href.split('#').shift(),data:data,success:function(response){self._setCacheData(term,response,paged);self._renderPosts(response,{term:term,isotopeData:isotopeData,page:paged});gridWrap.removeClass('woopack-is-filtering');}});},_renderPosts:function(response,args)
{var self=this,wrap=$(this.wrapperClass),gridWrap=$(this.nodeClass).find('.woopack-products-grid-wrap');if($(self.nodeClass).hasClass('woopack-products-loading')||('load_more'!==self.settings.pagination&&'scroll'!==self.settings.pagination)){wrap.isotope('remove',$(this.postClass));$(self.nodeClass).removeClass('woopack-products-loading');}
wrap.isotope('insert',$(response.data),$.proxy(this._isotopeCallback,this));wrap.find('.woopack-grid-sizer').remove();wrap.append('<li class="woopack-grid-sizer"></li>');wrap.imagesLoaded(function(){setTimeout(function(){if(!self.masonry){self._gridLayoutMatchHeight();}
wrap.isotope('layout');setTimeout(function(){self._initSlider();},500);},200);$(document).trigger('woopack.grid.rendered',[self]);});if(response.pagination){$(self.nodeClass).find('.fl-builder-pagination').remove();$(self.nodeClass).find('.fl-module-content').append(response.pagination);$(self.nodeClass).find('.woopack-ajax-pagination a').off('click').on('click',function(e){e.preventDefault();var pageNumber=$(this).attr('href').split('#page-')[1];self._getPosts(args.term,args.isotopeData,pageNumber);});}else{$(self.nodeClass).find('.fl-builder-pagination').remove();}
var offsetTop=gridWrap.offset().top-200;$('html, body').stop().animate({scrollTop:offsetTop},300);},_isotopeCallback:function(){var self=this,wrap=$(this.wrapperClass);if(!this.masonry){wrap.imagesLoaded(function(){setTimeout(function(){self._gridLayoutMatchHeight();},150);});}
$(this.wrapperClass).isotope('layout');$(this.nodeClass).removeClass('woopack-products-loading');},_setCacheData:function(filter,response,paged)
{if('undefined'===typeof filter||''===filter){filter='all';}
if('undefined'===typeof paged||!paged){paged=1;}
if('undefined'===typeof this.cacheData.ajaxCache){this.cacheData.ajaxCache={};}
if('undefined'===typeof this.cacheData.ajaxCache[filter]){this.cacheData.ajaxCache[filter]={};}
if('undefined'===typeof this.cacheData.ajaxCache[filter].page){this.cacheData.ajaxCache[filter].page={};}
return this.cacheData.ajaxCache[filter].page[paged]=response;},_getCacheData:function(filter)
{var cacheData=this.cacheData;if('undefined'===typeof cacheData.ajaxCache){cacheData.ajaxCache={};}
return cacheData.ajaxCache[filter];},_gridLayoutMatchHeight:function()
{var highestBox=0;var postElements=$(this.postClass+':visible');var columns=this.settings.columns.desktop;if(!this.matchHeight||1===columns){return;}
if('style-9'===this.style){return;}
if(this.masonry){return;}
if(window.innerWidth<=980){columns=this.settings.columns.medium;}
if(window.innerWidth<=767){columns=this.settings.columns.responsive;}
if(1===columns){return;}
postElements.css('height','auto');var rows=Math.round(postElements.length/columns);if(postElements.length%columns>0){rows=rows+1;}
var j=1,k=columns;for(var i=0;i<rows;i++){var postsInRow=$(this.postClass+':visible:nth-child(n+'+j+'):nth-child(-n+'+k+')');postsInRow.css('height','').each(function(){if($(this).height()>highestBox){highestBox=$(this).height();}});postsInRow.height(highestBox);j=k+1;k=k+columns;if(k>postElements.length){k=postElements.length;}
highestBox=0;}},_reLayout:function()
{var self=this;var wrap=$(this.wrapperClass);$(document).on('sf:ajaxfinish','.searchandfilter',function(){self._gridLayout();});$(document).on('facetwp-loaded',function(){wrap.imagesLoaded(function(){if(!self.masonry){self._gridLayoutMatchHeight();}
setTimeout(function(){self._initSlider();if(wrap.data('isotope')){wrap.isotope('destroy');}
self._gridLayout();},500);});});$(document).on('pp-tabs-switched',function(e,content){if(content.find(this.nodeClass).length===0){return;}
if(!self.masonry){self._gridLayoutMatchHeight();}
if(self.filters||self.masonry){if(content.find('ul.products').data('isotope')){content.find('ul.products').isotope('layout');}else{self._gridLayout();}}
setTimeout(function(){self._initSlider();},500);});},_initInfiniteScroll:function()
{if(this.settings.pagination=='scroll'&&typeof FLBuilder==='undefined'){this._infiniteScroll();}},_infiniteScroll:function(settings)
{$(this.wrapperClass).infinitescroll({navSelector:this.nodeClass+' .fl-builder-pagination',nextSelector:this.nodeClass+' .fl-builder-pagination a.next',itemSelector:this.postClass,prefill:true,bufferPx:200,animate:false,loading:{msgText:'Loading',finishedMsg:'',img:FLBuilderLayoutConfig.paths.pluginUrl+'img/ajax-loader-grey.gif',speed:1}},$.proxy(this._infiniteScrollComplete,this));setTimeout(function(){$(window).trigger('resize');},100);},_infiniteScrollComplete:function(elements)
{var self=this;var wrap=$(this.wrapperClass);elements=$(elements);if(!this.masonry){wrap.isotope('insert',elements,$.proxy(this._gridLayoutMatchHeight,this));wrap.imagesLoaded($.proxy(function(){setTimeout(function(){self._gridLayoutMatchHeight();},150);},this));}else{wrap.isotope('insert',elements);}
elements.css('visibility','visible');wrap.find('.woopack-grid-sizer').remove();wrap.append('<li class="woopack-grid-sizer"></li>');wrap.imagesLoaded($.proxy(function(){setTimeout(function(){if(!this.masonry){self._gridLayoutMatchHeight();}
wrap.isotope('layout');setTimeout(function(){self._initSlider();},500);},200);$(document).trigger('woopack.grid.rendered',[self]);},this));}};})(jQuery);;(function($){var WooPackGridOptions={id:'5fb364eea9229',layout:'1',layoutStyle:1,isCustomLayout:false,columns:{desktop:6,medium:2,responsive:1,},pagination:'numbers',perPage:'6',matchHeight:'no',filters:'no',filterTax:'product_brand',filterType:'static',fields:{"layout":"pre-defined","custom_layout":{"html":"[wpbb-if post:featured_image]\n<div class=\"woopack-product-image\">\n    [wpbb post:woocommerce_sale_flash]\n\t[wpbb post:featured_image size=\"large\" display=\"tag\" linked=\"yes\"]\n\t[wpbb post:woopack_quick_view_button icon='fas fa-eye' text='Quick View']\n<\/div>\n[\/wpbb-if]\n\n<div class=\"woopack-product-content\">\n\n    <h3 class=\"woopack-product-title\">[wpbb post:link text=\"title\"]<\/h3>\n    \n    <div class=\"woopack-product-rating\">\n        [wpbb post:woopack_product_rating show_count='yes' text_singular='customer review' text_plural='customer reviews']\n    <\/div>\n    \n    <div class=\"woopack-product-price\">\n        [wpbb post:woocommerce_product_price]\n    <\/div>\n    \n    [wpbb post:woopack_add_to_cart_button qty_input='before_button' variation_fields='no']\n\n    <div class=\"woopack-product-meta\">\n    \tCategory: \n\t\t[wpbb post:terms_list taxonomy=\"product_cat\" separator=\", \"]\n    <\/div>\n<\/div>\n","css":".woopack-product-image {\n\tposition: relative;\n    padding: 0;\n}\n.woopack-product-image a {\n    display: block;\n}\n.woopack-product-content {\n    padding: 0;\n}\n.woopack-product-title {\n\tmargin: 0;\n\tpadding: 0;\n}\n.woopack-product-rating .star-rating {\n\tmargin-left: auto;\n\tmargin-right: auto;\n}\n.woopack-product-meta {\n\tpadding: 0;\n\tmargin-top: 10px;\n}\n.woopack-product-meta a {\n\ttext-decoration: none;\n}\n.woopack-product-meta,\n.woopack-product-meta a {\n    font-size: 12px;\n}\n.woopack-product-action .woopack-qty-input,\n.woopack-product-action .variations_form .quantity {\n\tdisplay: inline-block;\n    margin-right: 2px;\n}\n.woopack-product-action.woopack-qty-custom .quantity {\n\tborder: 1px solid #ddd;\n}\n.woopack-product-action.woopack-qty-custom .quantity input.qty {\n\tborder: 1px solid #ddd;\n    border-top: 0;\n    border-bottom: 0;\n    background: none;\n    border-radius: 0;\n}\n.woopack-product-action form > table {\n\tmargin-left: auto;\n\tmargin-right: auto;\n\ttext-align: left;\n}\n.woopack-product-action form > table td.value {\n\tpadding: 2px 0px;\n}\n.woopack-product-action form > table td.label {\n\tcolor: inherit;\n    text-transform: capitalize;\n}\n.woopack-product-action form > table .reset_variations {\n\tmargin-left: 5px;\n}\n.woopack-product-quick-view {\n    background-color: rgba(255, 255, 255, 0.6);\n    position: absolute;\n    bottom: 0;\n    height: 50px;\n\twidth: 100%;\n\topacity: 0;\n    transition: all 0.3s;\n}\n.woopack-product-grid:hover .woopack-product-quick-view,\n.woopack-product-carousel:hover .woopack-product-quick-view {\n\topacity: 1;\n}\n.woopack-product-quick-icon + .woopack-quick-view-text {\n    margin-left: 10px;\n}"},"product_layout":"1","posts_per_page":"6","product_columns":"6","product_columns_medium":"2","product_columns_responsive":"1","product_spacing":"2","product_spacing_medium":"","product_spacing_responsive":"","product_align":"center","match_height":"no","enable_filter":"no","filter_taxonomy":"product_brand","filter_type":"static","filter_terms":"","filter_archive_terms":"","filter_all_label":"All","filter_position":"top","filter_alignment":"left","filter_color":"","filter_hover_color":"","filter_bg_color":"","filter_bg_hover_color":"","filter_border":"solid","filter_border_pos":"default","filter_border_el":"active","filter_border_width":"0","filter_border_color":"","filter_border_hover_color":"","filter_padding_v":"10","filter_padding_h":"10","filter_margin_h":"20","filter_margin_v":"20","filter_radius":"0","filter_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"pagination":"numbers","no_results_message":"Sorry, we couldn't find any products. Please try a different search.","show_search":"1","pagination_align":"center","pagination_bg_color":"rgba(77,79,0,0.37)","pagination_bg_color_hover":"","pagination_color":"","pagination_color_hover":"","pagination_border":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"pagination_border_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"pagination_border_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"pagination_border_color_hover":"","pagination_typography":{"font_family":"Helvetica","font_weight":"300","font_size":{"length":"16","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"center","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"pagination_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"pagination_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"content_bg_color":"rgba(77,79,0,0.13)","content_bg_color_hover":"","box_border_group":{"style":"solid","color":"rgba(77,79,0,0.61)","width":{"top":"1","right":"1","bottom":"1","left":"1"},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_hover_group":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_hover_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_hover_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"badge_position":"top-right","badge_bg_color":"f90008","badge_color":"f8fbfb","badge_margin_left_right":"7","badge_margin_left_right_medium":"","badge_margin_left_right_responsive":"","badge_margin_top_bottom":"4","badge_margin_top_bottom_medium":"","badge_margin_top_bottom_responsive":"","badge_padding_left_right":"10","badge_padding_left_right_medium":"","badge_padding_left_right_responsive":"","badge_padding_top_bottom":"","badge_padding_top_bottom_medium":"","badge_padding_top_bottom_responsive":"","sale_badge_border_group":{"style":"","color":"","width":{"top":"0","right":"0","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"sale_badge_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"sale_badge_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"out_of_stock_bg_color":"rgba(77,79,0,0.61)","out_of_stock_color":"ffffff","out_of_stock_border_group":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"out_of_stock_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"out_of_stock_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"meta_text_color":"","meta_link_color":"","meta_border":"yes","meta_border_color":"eeeeee","product_rating_size":"","product_rating_size_medium":"","product_rating_size_responsive":"","product_rating_default_color":"","product_rating_color":"","product_rating_margin_bottom":"10","product_rating_margin_bottom_medium":"","product_rating_margin_bottom_responsive":"","product_rating_count_color":"","quick_view_text_color":"","quick_view_bg_color":"","quick_view_popup_width":"auto","quick_view_popup_width_custom":"670","quick_view_popup_overlay_bg_color":"","variation_table_style":"no","variation_table_width":"full","variation_table_border":"1","variation_table_border_style":"solid","variation_table_border_color":"eeeeee","variation_table_cell_padding":"5","variation_table_label_bg_color":"fcfcfc","variation_table_label_text_color":"","variation_table_value_bg_color":"","variation_table_value_text_color":"","button_alignment":"center","button_width":"full_width","button_width_custom":"","button_width_custom_medium":"","button_width_custom_responsive":"","button_margin_top":"10","button_margin_top_medium":"","button_margin_top_responsive":"","button_margin_bottom":"10","button_margin_bottom_medium":"","button_margin_bottom_responsive":"","button_bg_color":"rgba(77,79,0,0.61)","button_bg_color_hover":"","button_color":"f8fbfb","button_color_hover":"","button_border_group":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"button_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"button_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"button_border_color_hover":"","button_typography":{"font_family":"Raleway","font_weight":"400","font_size":{"length":"12","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"button_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"button_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_heading_tag":"h5","product_title_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_color":"","product_title_color_hover":"","product_title_margin_top":"10","product_title_margin_top_medium":"","product_title_margin_top_responsive":"","product_title_margin_bottom":"10","product_title_margin_bottom_medium":"","product_title_margin_bottom_responsive":"","regular_price_typography":{"font_family":"Helvetica","font_weight":"300","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"regular_price_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"regular_price_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"regular_price_color":"","product_price_margin_bottom":"","product_price_margin_bottom_medium":"","product_price_margin_bottom_responsive":"","sale_price_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_price_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_price_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_price_color":"","short_description_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"short_description_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"short_description_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"short_description_color":"","product_description_margin_bottom":"","product_description_margin_bottom_medium":"","product_description_margin_bottom_responsive":"","sale_badge_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_badge_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_badge_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"out_of_stock_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"out_of_stock_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"out_of_stock_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"meta_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"meta_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"meta_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"rating_count_taxonomy":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"rating_count_taxonomy_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"rating_count_taxonomy_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"quick_view_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"quick_view_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"quick_view_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"responsive_display":"","visibility_display":"","visibility_user_capability":"","visibility_logic":"[]","animation":{"style":"","delay":"0","duration":"1"},"container_element":"div","id":"","class":"","export":"","import":"","pagination_padding_top":"0","pagination_padding_top_medium":"","pagination_padding_top_responsive":"","pagination_padding_right":"0","pagination_padding_right_medium":"","pagination_padding_right_responsive":"","pagination_padding_bottom":"0","pagination_padding_bottom_medium":"","pagination_padding_bottom_responsive":"","pagination_padding_left":"0","pagination_padding_left_medium":"","pagination_padding_left_responsive":"","pagination_margin_top":"0","pagination_margin_top_medium":"","pagination_margin_top_responsive":"","pagination_margin_right":"","pagination_margin_right_medium":"","pagination_margin_right_responsive":"","pagination_margin_bottom":"0","pagination_margin_bottom_medium":"","pagination_margin_bottom_responsive":"","pagination_margin_left":"","pagination_margin_left_medium":"","pagination_margin_left_responsive":"","box_padding_top":"0","box_padding_top_medium":"","box_padding_top_responsive":"","box_padding_right":"0","box_padding_right_medium":"","box_padding_right_responsive":"","box_padding_bottom":"0","box_padding_bottom_medium":"","box_padding_bottom_responsive":"","box_padding_left":"0","box_padding_left_medium":"","box_padding_left_responsive":"","content_padding_top":"0","content_padding_top_medium":"","content_padding_top_responsive":"","content_padding_right":"0","content_padding_right_medium":"","content_padding_right_responsive":"","content_padding_bottom":"0","content_padding_bottom_medium":"","content_padding_bottom_responsive":"","content_padding_left":"0","content_padding_left_medium":"","content_padding_left_responsive":"","out_of_stock_padding_top":"8","out_of_stock_padding_top_medium":"","out_of_stock_padding_top_responsive":"","out_of_stock_padding_right":"8","out_of_stock_padding_right_medium":"","out_of_stock_padding_right_responsive":"","out_of_stock_padding_bottom":"8","out_of_stock_padding_bottom_medium":"","out_of_stock_padding_bottom_responsive":"","out_of_stock_padding_left":"8","out_of_stock_padding_left_medium":"","out_of_stock_padding_left_responsive":"","meta_padding_top":"","meta_padding_top_medium":"","meta_padding_top_responsive":"","meta_padding_right":"","meta_padding_right_medium":"","meta_padding_right_responsive":"","meta_padding_bottom":"","meta_padding_bottom_medium":"","meta_padding_bottom_responsive":"","meta_padding_left":"","meta_padding_left_medium":"","meta_padding_left_responsive":"","quick_view_padding_top":"","quick_view_padding_top_medium":"","quick_view_padding_top_responsive":"","quick_view_padding_right":"","quick_view_padding_right_medium":"","quick_view_padding_right_responsive":"","quick_view_padding_bottom":"","quick_view_padding_bottom_medium":"","quick_view_padding_bottom_responsive":"","quick_view_padding_left":"","quick_view_padding_left_medium":"","quick_view_padding_left_responsive":"","button_padding_top":"10","button_padding_top_medium":"","button_padding_top_responsive":"","button_padding_right":"5","button_padding_right_medium":"","button_padding_right_responsive":"","button_padding_bottom":"10","button_padding_bottom_medium":"","button_padding_bottom_responsive":"","button_padding_left":"5","button_padding_left_medium":"","button_padding_left_responsive":"","margin_top":"5","margin_unit":"px","margin_top_medium":"","margin_medium_unit":"px","margin_top_responsive":"","margin_responsive_unit":"px","margin_right":"","margin_right_medium":"","margin_right_responsive":"","margin_bottom":"5","margin_bottom_medium":"","margin_bottom_responsive":"","margin_left":"","margin_left_medium":"","margin_left_responsive":"","type":"product-grid","item_html_tag":"li","layout_style":"grid","data_source":"custom_query","data_source_acf_relational_type":"relationship","data_source_acf_relational_key":"","post_type":"product","order":"DESC","order_by":"post__in","order_by_meta_key":"","offset":"0","product_source":"best_selling","exclude_current":"no","posts_product_matching":"1","posts_product":"","tax_product_product_brand_matching":"1","tax_product_product_brand":"","tax_product_product_cat_matching":"0","tax_product_product_cat":"38","tax_product_product_tag_matching":"1","tax_product_product_tag":"","users_matching":"1","users":"","product_title":"yes","product_price":"yes","product_rating":"yes","product_rating_count":"no","product_rating_text":"customer review","product_short_description":"no","show_image":"yes","image_size":"medium","image_slider":"no","show_sale_badge":"yes","out_of_stock_text":"Out of Stock","button_type":"cart","button_text":"View More","button_target":"_self","qty_input":"no","variation_fields":"no","show_taxonomy":"no","select_taxonomy":"product_brand","show_taxonomy_custom_text":"no","taxonomy_custom_text":"","show_quick_view":"yes","quick_view_custom_text":"Quick View","quick_view_type":"image_hover","quick_view_template":"","as_values_posts_product":"","as_values_tax_product_product_brand":"","as_values_tax_product_product_cat":"","as_values_tax_product_product_tag":"","as_values_users":"","connections":{"product_rating_text":"","taxonomy_custom_text":"","quick_view_custom_text":"","no_results_message":""}},template:'',imagesSlider:false,siteUrl:'https://www.premium-colostrum.com.au'};woopack_5fb364eea9229=new WooPackGrid(WooPackGridOptions);$(document).on('pp-tabs-switched',function(e,selector){if(selector.find('.woopack-grid-wrap').length>0){var wrap=selector.find('#woopack-5fb364eea9229 .woopack-products');if('undefined'!==typeof $.fn.isotope&&'undefined'!==typeof $.fn.imagesLoaded){setTimeout(function(){if(!wrap.hasClass('woopack-isotope-initialized')){wrap.imagesLoaded(function(){var hasSlider=false;if(wrap.find('.slick-slider').length>0){hasSlider=true;wrap.find('.slick-slider').slick('unslick');}
if(!wrap.data('isotope')){wrap.isotope(woopack_5fb364eea9229.isotopeData);}
if(hasSlider){woopack_5fb364eea9229._initSlider();}
wrap.isotope('layout');wrap.addClass('woopack-isotope-initialized');});}},500);}}});})(jQuery);jQuery(function($){$(function(){$('.fl-node-5fa34924952c8 .fl-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){UABBSpacerGap=function(settings)
{this.settings=settings;this.node=settings.id;this.desktop_space=settings.desktop_space;this.medium_device=settings.medium_device;this.small_device=settings.small_device;this.nodeClass='.fl-node-'+settings.id;this._init();};UABBSpacerGap.prototype={settings:{},node:'',nodeClass:'',_init:function()
{this._spacerGapHeightHandler();},_spacerGapHeightHandler:function()
{var nodeClass=jQuery(this.nodeClass);var node_id=nodeClass.data('node');var node='.fl-node-'+node_id+' ';if(jQuery('body').hasClass('fl-builder-edit')&&this.desktop_space<30){jQuery('body').find(node).addClass("uabb-desktop-spacer-height-adjustment");}
if(jQuery('body').hasClass('fl-builder-edit')&&this.medium_device<30){jQuery('body').find(node).addClass('uabb-tab-spacer-height-adjustment');}
if(jQuery('body').hasClass('fl-builder-edit')&&this.small_device<30){jQuery('body').find(node).addClass('uabb-mobile-spacer-height-adjustment');}},};})(jQuery);jQuery(document).ready(function(){new UABBSpacerGap({id:'5fa34924952d4',desktop_space:'40',medium_device:'10',small_device:'10',});});jQuery(document).ready(function(){new UABBSpacerGap({id:'5fa34924952da',desktop_space:'40',medium_device:'20',small_device:'10',});});jQuery(function($){$(function(){$('.fl-node-5e73ab1ecd540 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});jQuery(function($){$(function(){$('.fl-node-5e73abc6c2f02 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});jQuery(function($){$(function(){$('.fl-node-5e73abd2179c7 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){UABBImageCarousel=function(settings){this.id=settings.id;this.nodeClass='.fl-node-'+settings.id;this.infinite=settings.infinite;this.arrows=settings.arrows;this.slidesToScroll=settings.slidesToScroll;this.autoplay=settings.autoplay;this.on_pause_hover=settings.onhover;this.autoplaySpeed=settings.autoplaySpeed;this.desktop=settings.desktop;this.medium=settings.medium;this.small=settings.small;this.medium_breakpoint=settings.medium_breakpoint;this.small_breakpoint=settings.small_breakpoint;this.next_arrow=settings.next_arrow;this.prev_arrow=settings.prev_arrow;this.enable_fade=settings.enable_fade;this.enable_dots=settings.enable_dots;$(this.nodeClass).find('.uabb-image-carousel').on('init',$.proxy(this._adaptiveImageHeight,this));this._initImageCarousel();$(this.nodeClass).find('.uabb-image-carousel').on('lazyLoaded',$.proxy(this._adaptiveImageHeight,this));};UABBImageCarousel.prototype={nodeClass:'',wrapperClass:'',infinite:'',arrows:'',desktop:'',medium:'',small:'',slidesToScroll:'',autoplay:'',autoplaySpeed:'',small_breakpoint:'',medium_breakpoint:'',_initImageCarousel:function(){var node=$(this.nodeClass),img_carousel=node.find('.uabb-image-carousel');img_carousel.uabbslick({dots:this.enable_dots,fade:this.enable_fade,infinite:this.infinite,arrows:this.arrows,lazyLoad:'ondemand',slidesToShow:this.desktop,slidesToScroll:this.slidesToScroll,autoplay:this.autoplay,pauseOnHover:this.on_pause_hover,autoplaySpeed:this.autoplaySpeed,adaptiveHeight:true,prevArrow:'<button type="button" data-role="none" class="slick-prev" aria-label="Previous" tabindex="0" role="button"><i class=" '+this.prev_arrow+' "></i></button>',nextArrow:'<button type="button" data-role="none" class="slick-next" aria-label="Next" tabindex="0" role="button"><i class="'+this.next_arrow+' "></i></button>',responsive:[{breakpoint:this.medium_breakpoint,settings:{slidesToShow:this.medium}},{breakpoint:this.small_breakpoint,settings:{slidesToShow:this.small,}}]});img_carousel.on('afterChange',$.proxy(this._adaptiveImageHeight,this));},_adaptiveImageHeight:function(){var node=$(this.nodeClass),post_active=node.find('.uabb-image-carousel-item.slick-active'),max_height=-1;post_active.each(function(i){var $this=$(this),this_height=$this.innerHeight();if(max_height<this_height){max_height=this_height;}});node.find('.uabb-image-carousel .slick-list.draggable').animate({height:max_height},{duration:200,easing:'linear'});max_height=-1;}};})(jQuery);jQuery(document).ready(function($){var args={id:'5fa48c5ac3cd1',infinite:true,arrows:true,desktop:5,medium:3,small:2,slidesToScroll:1,autoplay:true,onhover:false,autoplaySpeed:2000,small_breakpoint:768,medium_breakpoint:992,next_arrow:'fas fa-angle-right',prev_arrow:'fas fa-angle-left',enable_fade:false,enable_dots:false};UABBImageCarousel_5fa48c5ac3cd1=new UABBImageCarousel(args);$(window).on("load",function(){UABBImageCarousel_5fa48c5ac3cd1._adaptiveImageHeight();});var UABBImageCarouselResize_5fa48c5ac3cd1;$(window).resize(function(){clearTimeout(UABBImageCarouselResize_5fa48c5ac3cd1);UABBImageCarouselResize_5fa48c5ac3cd1=setTimeout(UABBImageCarousel_5fa48c5ac3cd1._adaptiveImageHeight,500);});$('.fl-node-5fa48c5ac3cd1 .uabb-image-carousel').magnificPopup({delegate:'.uabb-image-carousel-content a',closeBtnInside:false,type:'image',gallery:{enabled:true,navigateByImgClick:true,},'image':{titleSrc:function(item){}}});$(function(){$('.fl-node-5fa48c5ac3cd1 .uabb-gallery-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){var arrObj=new Array();jQuery('.fl-node-5fa491526ab6b .uabb-slider-next').empty();jQuery('.fl-node-5fa491526ab6b .uabb-slider-prev').empty();var testimonial_5fa491526ab6b=jQuery('.fl-node-5fa491526ab6b .uabb-testimonials').bxSlider({autoStart:1,auto:true,autoHover:true,adaptiveHeight:false,pause:10000,mode:'horizontal',speed:500,pager:1,nextSelector:'.fl-node-5fa491526ab6b .uabb-slider-next',prevSelector:'.fl-node-5fa491526ab6b .uabb-slider-prev',nextText:'<i class="fa fa-chevron-right"></i>',prevText:'<i class="fa fa-chevron-left"></i>',controls:0,onSliderLoad:function(){jQuery('.fl-node-5fa491526ab6b .uabb-testimonials').addClass('uabb-testimonials-loaded');}});arrObj['testimonial_5fa491526ab6b']=testimonial_5fa491526ab6b;UABBTrigger.addHook('uabb-modal-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){testimonial_5fa491526ab6b.reloadSlider();},250);}});UABBTrigger.addHook('uabb-accordion-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});UABBTrigger.addHook('uabb-tab-click',function(argument,selector){if(jQuery(selector).find('.uabb-testimonials')){setTimeout(function(){var child_id=jQuery(selector).find('.fl-module-adv-testimonials').data('node');if(child_id!==null&&arrObj['testimonial_'+child_id]!==undefined){arrObj['testimonial_'+child_id].reloadSlider();}},250);}});jQuery(window).on('load',function(){testimonial_5fa491526ab6b.reloadSlider();});})(jQuery);;(function($){var WooPackGridOptions={id:'5fb3691b9c29d',layout:'1',layoutStyle:1,isCustomLayout:false,columns:{desktop:4,medium:2,responsive:1,},pagination:'numbers',perPage:'8',matchHeight:'no',filters:'no',filterTax:'product_brand',filterType:'static',fields:{"layout":"pre-defined","custom_layout":{"html":"[wpbb-if post:featured_image]\n<div class=\"woopack-product-image\">\n    [wpbb post:woocommerce_sale_flash]\n\t[wpbb post:featured_image size=\"large\" display=\"tag\" linked=\"yes\"]\n\t[wpbb post:woopack_quick_view_button icon='fas fa-eye' text='Quick View']\n<\/div>\n[\/wpbb-if]\n\n<div class=\"woopack-product-content\">\n\n    <h3 class=\"woopack-product-title\">[wpbb post:link text=\"title\"]<\/h3>\n    \n    <div class=\"woopack-product-rating\">\n        [wpbb post:woopack_product_rating show_count='yes' text_singular='customer review' text_plural='customer reviews']\n    <\/div>\n    \n    <div class=\"woopack-product-price\">\n        [wpbb post:woocommerce_product_price]\n    <\/div>\n    \n    [wpbb post:woopack_add_to_cart_button qty_input='before_button' variation_fields='no']\n\n    <div class=\"woopack-product-meta\">\n    \tCategory: \n\t\t[wpbb post:terms_list taxonomy=\"product_cat\" separator=\", \"]\n    <\/div>\n<\/div>\n","css":".woopack-product-image {\n\tposition: relative;\n    padding: 0;\n}\n.woopack-product-image a {\n    display: block;\n}\n.woopack-product-content {\n    padding: 0;\n}\n.woopack-product-title {\n\tmargin: 0;\n\tpadding: 0;\n}\n.woopack-product-rating .star-rating {\n\tmargin-left: auto;\n\tmargin-right: auto;\n}\n.woopack-product-meta {\n\tpadding: 0;\n\tmargin-top: 10px;\n}\n.woopack-product-meta a {\n\ttext-decoration: none;\n}\n.woopack-product-meta,\n.woopack-product-meta a {\n    font-size: 12px;\n}\n.woopack-product-action .woopack-qty-input,\n.woopack-product-action .variations_form .quantity {\n\tdisplay: inline-block;\n    margin-right: 2px;\n}\n.woopack-product-action.woopack-qty-custom .quantity {\n\tborder: 1px solid #ddd;\n}\n.woopack-product-action.woopack-qty-custom .quantity input.qty {\n\tborder: 1px solid #ddd;\n    border-top: 0;\n    border-bottom: 0;\n    background: none;\n    border-radius: 0;\n}\n.woopack-product-action form > table {\n\tmargin-left: auto;\n\tmargin-right: auto;\n\ttext-align: left;\n}\n.woopack-product-action form > table td.value {\n\tpadding: 2px 0px;\n}\n.woopack-product-action form > table td.label {\n\tcolor: inherit;\n    text-transform: capitalize;\n}\n.woopack-product-action form > table .reset_variations {\n\tmargin-left: 5px;\n}\n.woopack-product-quick-view {\n    background-color: rgba(255, 255, 255, 0.6);\n    position: absolute;\n    bottom: 0;\n    height: 50px;\n\twidth: 100%;\n\topacity: 0;\n    transition: all 0.3s;\n}\n.woopack-product-grid:hover .woopack-product-quick-view,\n.woopack-product-carousel:hover .woopack-product-quick-view {\n\topacity: 1;\n}\n.woopack-product-quick-icon + .woopack-quick-view-text {\n    margin-left: 10px;\n}"},"product_layout":"1","posts_per_page":"8","product_columns":"4","product_columns_medium":"2","product_columns_responsive":"1","product_spacing":"2","product_spacing_medium":"","product_spacing_responsive":"","product_align":"center","match_height":"no","enable_filter":"no","filter_taxonomy":"product_brand","filter_type":"static","filter_terms":"","filter_archive_terms":"","filter_all_label":"All","filter_position":"top","filter_alignment":"left","filter_color":"","filter_hover_color":"","filter_bg_color":"","filter_bg_hover_color":"","filter_border":"solid","filter_border_pos":"default","filter_border_el":"active","filter_border_width":"0","filter_border_color":"","filter_border_hover_color":"","filter_padding_v":"10","filter_padding_h":"10","filter_margin_h":"20","filter_margin_v":"20","filter_radius":"0","filter_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"filter_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"pagination":"numbers","no_results_message":"Sorry, we couldn't find any products. Please try a different search.","show_search":"1","pagination_align":"center","pagination_bg_color":"rgba(77,79,0,0.37)","pagination_bg_color_hover":"","pagination_color":"","pagination_color_hover":"","pagination_border":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"pagination_border_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"pagination_border_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"pagination_border_color_hover":"","pagination_typography":{"font_family":"Helvetica","font_weight":"300","font_size":{"length":"16","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"center","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"pagination_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"pagination_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"content_bg_color":"rgba(77,79,0,0.13)","content_bg_color_hover":"","box_border_group":{"style":"solid","color":"rgba(77,79,0,0.61)","width":{"top":"1","right":"1","bottom":"1","left":"1"},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_hover_group":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_hover_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"box_border_hover_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"badge_position":"top-right","badge_bg_color":"f90008","badge_color":"f8fbfb","badge_margin_left_right":"7","badge_margin_left_right_medium":"","badge_margin_left_right_responsive":"","badge_margin_top_bottom":"4","badge_margin_top_bottom_medium":"","badge_margin_top_bottom_responsive":"","badge_padding_left_right":"10","badge_padding_left_right_medium":"","badge_padding_left_right_responsive":"","badge_padding_top_bottom":"","badge_padding_top_bottom_medium":"","badge_padding_top_bottom_responsive":"","sale_badge_border_group":{"style":"","color":"","width":{"top":"0","right":"0","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"sale_badge_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"sale_badge_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"out_of_stock_bg_color":"rgba(77,79,0,0.61)","out_of_stock_color":"ffffff","out_of_stock_border_group":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"out_of_stock_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"out_of_stock_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"meta_text_color":"","meta_link_color":"","meta_border":"yes","meta_border_color":"eeeeee","product_rating_size":"","product_rating_size_medium":"","product_rating_size_responsive":"","product_rating_default_color":"","product_rating_color":"","product_rating_margin_bottom":"10","product_rating_margin_bottom_medium":"","product_rating_margin_bottom_responsive":"","product_rating_count_color":"","quick_view_text_color":"","quick_view_bg_color":"","quick_view_popup_width":"auto","quick_view_popup_width_custom":"670","quick_view_popup_overlay_bg_color":"","variation_table_style":"no","variation_table_width":"full","variation_table_border":"1","variation_table_border_style":"solid","variation_table_border_color":"eeeeee","variation_table_cell_padding":"5","variation_table_label_bg_color":"fcfcfc","variation_table_label_text_color":"","variation_table_value_bg_color":"","variation_table_value_text_color":"","button_alignment":"center","button_width":"full_width","button_width_custom":"","button_width_custom_medium":"","button_width_custom_responsive":"","button_margin_top":"10","button_margin_top_medium":"","button_margin_top_responsive":"","button_margin_bottom":"10","button_margin_bottom_medium":"","button_margin_bottom_responsive":"","button_bg_color":"rgba(77,79,0,0.61)","button_bg_color_hover":"","button_color":"f8fbfb","button_color_hover":"","button_border_group":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"button_border_group_medium":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"button_border_group_responsive":{"style":"","color":"","width":{"top":"","right":"","bottom":"","left":""},"radius":{"top_left":"","top_right":"","bottom_left":"","bottom_right":""},"shadow":{"color":"","horizontal":"","vertical":"","blur":"","spread":""}},"button_border_color_hover":"","button_typography":{"font_family":"Raleway","font_weight":"400","font_size":{"length":"12","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"button_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"button_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_heading_tag":"h5","product_title_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"product_title_color":"","product_title_color_hover":"","product_title_margin_top":"10","product_title_margin_top_medium":"","product_title_margin_top_responsive":"","product_title_margin_bottom":"10","product_title_margin_bottom_medium":"","product_title_margin_bottom_responsive":"","regular_price_typography":{"font_family":"Helvetica","font_weight":"300","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"regular_price_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"regular_price_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"regular_price_color":"","product_price_margin_bottom":"","product_price_margin_bottom_medium":"","product_price_margin_bottom_responsive":"","sale_price_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_price_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_price_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_price_color":"","short_description_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"short_description_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"short_description_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"short_description_color":"","product_description_margin_bottom":"","product_description_margin_bottom_medium":"","product_description_margin_bottom_responsive":"","sale_badge_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_badge_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"sale_badge_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"out_of_stock_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"out_of_stock_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"out_of_stock_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"meta_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"meta_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"meta_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"rating_count_taxonomy":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"rating_count_taxonomy_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"rating_count_taxonomy_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"quick_view_typography":{"font_family":"Default","font_weight":"default","font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"quick_view_typography_medium":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"quick_view_typography_responsive":{"font_size":{"length":"","unit":"px"},"line_height":{"length":"","unit":""},"text_align":"","letter_spacing":{"length":""},"text_transform":"","text_decoration":"","font_style":"","font_variant":"","text_shadow":{"color":"","horizontal":"","vertical":"","blur":""}},"responsive_display":"","visibility_display":"","visibility_user_capability":"","visibility_logic":"[]","animation":{"style":"","delay":"0","duration":"1"},"container_element":"div","id":"","class":"","export":"","import":"","pagination_padding_top":"0","pagination_padding_top_medium":"","pagination_padding_top_responsive":"","pagination_padding_right":"0","pagination_padding_right_medium":"","pagination_padding_right_responsive":"","pagination_padding_bottom":"0","pagination_padding_bottom_medium":"","pagination_padding_bottom_responsive":"","pagination_padding_left":"0","pagination_padding_left_medium":"","pagination_padding_left_responsive":"","pagination_margin_top":"0","pagination_margin_top_medium":"","pagination_margin_top_responsive":"","pagination_margin_right":"","pagination_margin_right_medium":"","pagination_margin_right_responsive":"","pagination_margin_bottom":"0","pagination_margin_bottom_medium":"","pagination_margin_bottom_responsive":"","pagination_margin_left":"","pagination_margin_left_medium":"","pagination_margin_left_responsive":"","box_padding_top":"0","box_padding_top_medium":"","box_padding_top_responsive":"","box_padding_right":"0","box_padding_right_medium":"","box_padding_right_responsive":"","box_padding_bottom":"0","box_padding_bottom_medium":"","box_padding_bottom_responsive":"","box_padding_left":"0","box_padding_left_medium":"","box_padding_left_responsive":"","content_padding_top":"0","content_padding_top_medium":"","content_padding_top_responsive":"","content_padding_right":"0","content_padding_right_medium":"","content_padding_right_responsive":"","content_padding_bottom":"0","content_padding_bottom_medium":"","content_padding_bottom_responsive":"","content_padding_left":"0","content_padding_left_medium":"","content_padding_left_responsive":"","out_of_stock_padding_top":"8","out_of_stock_padding_top_medium":"","out_of_stock_padding_top_responsive":"","out_of_stock_padding_right":"8","out_of_stock_padding_right_medium":"","out_of_stock_padding_right_responsive":"","out_of_stock_padding_bottom":"8","out_of_stock_padding_bottom_medium":"","out_of_stock_padding_bottom_responsive":"","out_of_stock_padding_left":"8","out_of_stock_padding_left_medium":"","out_of_stock_padding_left_responsive":"","meta_padding_top":"","meta_padding_top_medium":"","meta_padding_top_responsive":"","meta_padding_right":"","meta_padding_right_medium":"","meta_padding_right_responsive":"","meta_padding_bottom":"","meta_padding_bottom_medium":"","meta_padding_bottom_responsive":"","meta_padding_left":"","meta_padding_left_medium":"","meta_padding_left_responsive":"","quick_view_padding_top":"","quick_view_padding_top_medium":"","quick_view_padding_top_responsive":"","quick_view_padding_right":"","quick_view_padding_right_medium":"","quick_view_padding_right_responsive":"","quick_view_padding_bottom":"","quick_view_padding_bottom_medium":"","quick_view_padding_bottom_responsive":"","quick_view_padding_left":"","quick_view_padding_left_medium":"","quick_view_padding_left_responsive":"","button_padding_top":"10","button_padding_top_medium":"","button_padding_top_responsive":"","button_padding_right":"5","button_padding_right_medium":"","button_padding_right_responsive":"","button_padding_bottom":"10","button_padding_bottom_medium":"","button_padding_bottom_responsive":"","button_padding_left":"5","button_padding_left_medium":"","button_padding_left_responsive":"","margin_top":"5","margin_unit":"px","margin_top_medium":"","margin_medium_unit":"px","margin_top_responsive":"","margin_responsive_unit":"px","margin_right":"","margin_right_medium":"","margin_right_responsive":"","margin_bottom":"5","margin_bottom_medium":"","margin_bottom_responsive":"","margin_left":"","margin_left_medium":"","margin_left_responsive":"","type":"product-grid","item_html_tag":"li","layout_style":"grid","data_source":"custom_query","data_source_acf_relational_type":"relationship","data_source_acf_relational_key":"","post_type":"product","order":"DESC","order_by":"modified","order_by_meta_key":"","offset":"0","product_source":"all","exclude_current":"no","posts_product_matching":"1","posts_product":"","tax_product_product_brand_matching":"1","tax_product_product_brand":"","tax_product_product_cat_matching":"1","tax_product_product_cat":"","tax_product_product_tag_matching":"1","tax_product_product_tag":"","users_matching":"1","users":"","product_title":"yes","product_price":"yes","product_rating":"yes","product_rating_count":"no","product_rating_text":"customer review","product_short_description":"no","show_image":"yes","image_size":"medium","image_slider":"no","show_sale_badge":"yes","out_of_stock_text":"Out of Stock","button_type":"cart","button_text":"View More","button_target":"_self","qty_input":"no","variation_fields":"no","show_taxonomy":"no","select_taxonomy":"product_brand","show_taxonomy_custom_text":"no","taxonomy_custom_text":"","show_quick_view":"yes","quick_view_custom_text":"Quick View","quick_view_type":"image_hover","quick_view_template":"","as_values_posts_product":"","as_values_tax_product_product_brand":"","as_values_tax_product_product_cat":"","as_values_tax_product_product_tag":"","as_values_users":"","connections":{"product_rating_text":"","taxonomy_custom_text":"","quick_view_custom_text":"","no_results_message":""}},template:'',imagesSlider:false,siteUrl:'https://www.premium-colostrum.com.au'};woopack_5fb3691b9c29d=new WooPackGrid(WooPackGridOptions);$(document).on('pp-tabs-switched',function(e,selector){if(selector.find('.woopack-grid-wrap').length>0){var wrap=selector.find('#woopack-5fb3691b9c29d .woopack-products');if('undefined'!==typeof $.fn.isotope&&'undefined'!==typeof $.fn.imagesLoaded){setTimeout(function(){if(!wrap.hasClass('woopack-isotope-initialized')){wrap.imagesLoaded(function(){var hasSlider=false;if(wrap.find('.slick-slider').length>0){hasSlider=true;wrap.find('.slick-slider').slick('unslick');}
if(!wrap.data('isotope')){wrap.isotope(woopack_5fb3691b9c29d.isotopeData);}
if(hasSlider){woopack_5fb3691b9c29d._initSlider();}
wrap.isotope('layout');wrap.addClass('woopack-isotope-initialized');});}},500);}}});})(jQuery);(function($){window.onLoadUABBReCaptcha=function(){var reCaptchaFields=$('.uabb-grecaptcha'),widgetID;if(reCaptchaFields.length>0){reCaptchaFields.each(function(){var self=$(this),attrWidget=self.attr('data-widgetid');if((typeof attrWidget!==typeof undefined&&attrWidget!==false)){return;}
else{widgetID=grecaptcha.render($(this).attr('id'),{sitekey:self.data('sitekey'),theme:self.data('theme'),callback:function(response){if(response!=''){self.attr('data-uabb-grecaptcha-response',response);}}});self.attr('data-widgetid',widgetID);}});}};UABBContactForm=function(settings)
{this.settings=settings;this.nodeClass='.fl-node-'+settings.id;this.ajaxurl=settings.uabb_ajaxurl;this.name_required=settings.name_required;this.email_required=settings.email_required;this.subject_required=settings.subject_required;this.phone_required=settings.phone_required;this.msg_required=settings.msg_required;this.msg_toggle=settings.msg_toggle;this.button_text=settings.button_text;this.form=$(this.nodeClass+' .uabb-contact-form');this.button=this.form.find('.uabb-contact-form-submit');this.recaptcha_version=settings.recaptcha_version;reCaptchaField=$('#'+this.settings.id+'-uabb-grecaptcha');reCaptchaValue=reCaptchaField.data('uabb-grecaptcha-response');if('v3'===this.recaptcha_version&&reCaptchaField.length>0){grecaptcha.ready(function(){recaptcha_id=reCaptchaField.attr('data-widgetid');grecaptcha.execute(recaptcha_id);});}
this._init();};UABBContactForm.prototype={settings:{},nodeClass:'',ajaxurl:'',name_required:'no',email_required:'yes',subject_required:'no',phone_required:'no',msg_required:'no',_init:function()
{var phone=$(this.nodeClass+' .uabb-phone input');phone.on('keyup',this._removeExtraSpaces);$(this.nodeClass+' .uabb-contact-form-submit').click($.proxy(this._submit,this));},_submit:function(e)
{var theForm=$(this.nodeClass+' .uabb-contact-form'),submit=$(this.nodeClass+' .uabb-contact-form-submit'),name=$(this.nodeClass+' .uabb-name input'),email=$(this.nodeClass+' .uabb-email input'),phone=$(this.nodeClass+' .uabb-phone input'),subject=$(this.nodeClass+' .uabb-subject input'),message=$(this.nodeClass+' .uabb-message textarea'),reCaptchaField=$('#'+this.settings.id+'-uabb-grecaptcha'),reCaptchaValue=reCaptchaField.data('uabb-grecaptcha-response'),mailto=$(this.nodeClass+' .uabb-mailto'),ajaxurl=this.ajaxurl,_nonce=theForm.data('nonce'),email_regex=/\S+@\S+\.\S+/,phone_regex=/^[ 0-9.()\[\]+-]*$/,isValid=true;termsCheckbox=$(this.nodeClass+' .uabb-terms-checkbox input'),postId=theForm.closest('.fl-builder-content').data('post-id'),templateId=theForm.data('template-id'),templateNodeId=theForm.data('template-node-id'),nodeId=theForm.closest('.fl-module').data('node');e.preventDefault();name.on('focus',this._removeErrorClass);email.on('focus',this._removeErrorClass);phone.on('focus',this._removeErrorClass);phone.on('keyup',this._removeExtraSpaces);subject.on('focus',this._removeErrorClass);message.on('focus',this._removeErrorClass);if(submit.hasClass('uabb-disabled')){return;}
if(this.name_required=='yes'){if(name.length){if(name.val().trim()===''){isValid=false;name.parent().addClass('uabb-error');name.addClass('uabb-form-error');name.siblings('.uabb-form-error-message').show();}
else if(name.parent().hasClass('uabb-error')){name.parent().removeClass('uabb-error');name.siblings('.uabb-form-error-message').hide();}}}
if(this.email_required=='yes'){if(email.length){if(email.val().trim()===''){isValid=false;email.parent().addClass('uabb-error');email.siblings('.uabb-form-error-message').show();email.siblings().addClass('uabb-form-error-message-required');}
else{email.siblings().removeClass('uabb-form-error-message-required');email.parent().removeClass('uabb-error');email.siblings('.uabb-form-error-message').hide();}}}else{email.siblings().removeClass('uabb-form-error-message-required');}
if(email.length){if(email.val().trim()!==''){if(email_regex.test(email.val().trim())){email.parent().removeClass('uabb-error');email.siblings('.uabb-form-error-message').hide();}else{isValid=false;email.parent().addClass('uabb-error');email.siblings('.uabb-form-error-message').show();}}}
if(this.subject_required=='yes'){if(subject.length){if(subject.val().trim()===''){isValid=false;subject.parent().addClass('uabb-error');subject.siblings('.uabb-form-error-message').show();}
else if(subject.parent().hasClass('uabb-error')){subject.parent().removeClass('uabb-error');subject.siblings('.uabb-form-error-message').hide();}}}
if(this.phone_required=='yes'){if(phone.length){if(phone.val().trim()===''){isValid=false;phone.parent().addClass('uabb-error');phone.siblings('.uabb-form-error-message').show();phone.siblings().addClass('uabb-form-error-message-required');}else{phone.siblings().removeClass('uabb-form-error-message-required');phone.parent().removeClass('uabb-error');phone.siblings('.uabb-form-error-message').hide();}}}else{phone.siblings().removeClass('uabb-form-error-message-required');}
if(phone.length){if(phone.val().trim()!==''){if(phone_regex.test(phone.val().trim())){phone.parent().removeClass('uabb-error');phone.siblings('.uabb-form-error-message').hide();}else{isValid=false;phone.parent().addClass('uabb-error');phone.siblings('.uabb-form-error-message').show();}}}
if((this.msg_required=='yes')&&(this.msg_toggle=='show')){if(message.val().trim()===''){isValid=false;message.parent().addClass('uabb-error');message.siblings('.uabb-form-error-message').show();}
else if(message.parent().hasClass('uabb-error')){message.parent().removeClass('uabb-error');message.siblings('.uabb-form-error-message').hide();}}
if(termsCheckbox.length){if(!termsCheckbox.is(':checked')){isValid=false;termsCheckbox.closest('.uabb-contact-form .uabb-terms-checkbox').addClass('uabb-error');}
else if(termsCheckbox.closest('.uabb-contact-form .uabb-terms-checkbox').hasClass('uabb-error')){termsCheckbox.closest('.uabb-contact-form .uabb-terms-checkbox').removeClass('uabb-error');}}
if('v2'==this.recaptcha_version&&reCaptchaField.length>0){if('undefined'===typeof reCaptchaValue||reCaptchaValue===false){isValid=false;reCaptchaField.parent().addClass('uabb-error');}else{reCaptchaField.parent().removeClass('uabb-error');}}
if(!isValid){return false;}
else{$recaptcha_version=this.recaptcha_version;submit.addClass('uabb-disabled');submit.html('<span>'+this.button.closest('.uabb-contact-form-button').data('wait-text')+'</span>');$reCaptchaValue=reCaptchaValue;$.post(ajaxurl,{action:'uabb_builder_email',security:_nonce,name:name.val(),subject:subject.val(),email:email.val(),phone:phone.val(),mailto:mailto.val(),message:message.val(),recaptcha_version:$recaptcha_version,recaptcha_response:reCaptchaValue,terms_checked:termsCheckbox.is(':checked')?'1':'0',post_id:postId,node_id:nodeId,template_id:templateId,template_node_id:templateNodeId},$.proxy(this._submitComplete,this));}},_removeExtraSpaces:function(){var textValue=$(this).val();textValue=textValue.replace(/ /g,"");$(this).val(textValue)},_removeErrorClass:function(){$(this).parent().removeClass('uabb-error');$(this).siblings('.uabb-form-error-message').hide();},_submitComplete:function(response){var urlField=$(this.nodeClass+' .uabb-success-url'),submit=$(this.nodeClass+' .uabb-contact-form-submit'),noMessage=$(this.nodeClass+' .uabb-success-none');submit.html('<span>'+this.button_text+'</span>');if(response==='1'||response==1||response=='1'){$(this.nodeClass+' .uabb-send-error').fadeOut();if(urlField.length>0){window.location.href=urlField.val();}
else if(noMessage.length>0){noMessage.fadeIn();}
else{$(this.nodeClass+' .uabb-contact-form').hide();$(this.nodeClass+' .uabb-success-msg').fadeIn();}}
else{$(this.nodeClass+' .uabb-contact-form-submit').removeClass('uabb-disabled');$(this.nodeClass+' .uabb-send-error').fadeIn();return false;}}};})(jQuery);(function($){$(function(){new UABBContactForm({id:"5fa497b5ae68d",uabb_ajaxurl:"https://www.premium-colostrum.com.au/wp-admin/admin-ajax.php",name_required:"no",email_required:"yes",subject_required:"no",phone_required:"no",msg_required:"no",msg_toggle:"hide",button_text:"SUBSCRIBE",recaptcha_version:'v2',});});})(jQuery);(function($){jQuery(document).ready(function(){});})(jQuery);jQuery(function($){$(function(){$('.fl-node-5e74c93d8a101 .uabb-photo-img').on('mouseenter',function(e){$(this).data('title',$(this).attr('title')).removeAttr('title');}).on('mouseleave',function(e){$(this).attr('title',$(this).data('title')).data('title',null);});});});(function($){jQuery(document).ready(function(){});})(jQuery);